/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import dk.mrspring.kitchen.ModLogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityBase
extends TileEntity {
    public static final String NBT_LEVEL = "NBTLevel";
    public static final String NBT_DATA = "NBTData";

    public abstract void readDataFromNBT(NBTTagCompound var1);

    public abstract void writeDataToNBT(NBTTagCompound var1);

    public abstract int getNBTLevel();

    public abstract void readDataFromOldNBT(int var1, int var2, NBTTagCompound var3);

    public void spawn(ItemStack ... stacks) {
        this.spawn((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, stacks);
    }

    public void spawn(double x, double y, double z, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), x, y, z, stack));
        }
    }

    public void warnNBTLevelChange(int oldLevel, int newLevel) {
        ModLogger.print(1, "Reading from unknown NBT level: " + oldLevel + "! Things might go wrong...");
    }

    public void mark() {
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_150297_b(NBT_LEVEL, 3)) {
            this.readDataFromNBT(compound);
        } else {
            int currentLevel;
            int compoundLevel = compound.func_74762_e(NBT_LEVEL);
            if (compoundLevel != (currentLevel = this.getNBTLevel())) {
                this.readDataFromOldNBT(compoundLevel, currentLevel, compound.func_74775_l(NBT_DATA));
            } else {
                this.readDataFromNBT(compound.func_74775_l(NBT_DATA));
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a(NBT_LEVEL, this.getNBTLevel());
        NBTTagCompound data = new NBTTagCompound();
        this.writeDataToNBT(data);
        compound.func_74782_a(NBT_DATA, (NBTBase)data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, compound);
    }
}

