/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import dk.mrspring.kitchen.ModConfig;
import dk.mrspring.kitchen.api.event.BoardEventRegistry;
import dk.mrspring.kitchen.api.event.IOnAddedToBoardEvent;
import dk.mrspring.kitchen.api.event.IOnBoardRightClickedEvent;
import dk.mrspring.kitchen.api.event.ITopItemEvent;
import dk.mrspring.kitchen.config.SandwichableConfig;
import dk.mrspring.kitchen.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityBoard
extends TileEntityBase {
    private List<ItemStack> layers = new ArrayList<ItemStack>();
    private NBTTagCompound specialInfo = new NBTTagCompound();

    public boolean rightClicked(ItemStack toAdd, boolean callEvents) {
        if (toAdd != null) {
            IOnAddedToBoardEvent onAddedToBoardEvent = (IOnAddedToBoardEvent)BoardEventRegistry.getOnAddedToBoardEventFor(toAdd.func_77973_b());
            ITopItemEvent topItemEvent = (ITopItemEvent)BoardEventRegistry.getTopItemEventFor(this.getTop());
            if (!callEvents) {
                onAddedToBoardEvent = BoardEventRegistry.getDefaultOnAddedToBoardEvent();
                topItemEvent = BoardEventRegistry.getDefaultTopItemEvent();
            }
            NBTTagCompound compoundCopy = this.getSpecialInfo();
            if (ModConfig.getSandwichConfig().canAdd(toAdd) && topItemEvent.canAddItemOnTop(this.getLayers(), toAdd, compoundCopy) && onAddedToBoardEvent.canAdd(this.getLayers(), toAdd, compoundCopy)) {
                ItemStack temp = onAddedToBoardEvent.addedToBoard(this.getLayers(), toAdd, this.getSpecialInfo());
                temp.field_77994_a = 1;
                this.layers.add(temp);
                this.setSpecialInfo(new NBTTagCompound());
                compoundCopy = this.getSpecialInfo();
                onAddedToBoardEvent.onAdded(this.getLayers(), toAdd, compoundCopy);
                this.setSpecialInfo(compoundCopy);
                return onAddedToBoardEvent.decrementStackSize(this.getLayers(), toAdd, this.getSpecialInfo());
            }
            IOnBoardRightClickedEvent onBoardRightClickedEvent = (IOnBoardRightClickedEvent)BoardEventRegistry.getOnBoardRightClickedEventFor(toAdd.func_77973_b());
            if (!callEvents) {
                onBoardRightClickedEvent = BoardEventRegistry.getDefaultOnBoardRightClickedEvent();
            }
            compoundCopy = this.getSpecialInfo();
            onBoardRightClickedEvent.onRightClicked(this.getLayers(), toAdd, compoundCopy);
            this.setSpecialInfo(compoundCopy);
            return false;
        }
        return false;
    }

    public NBTTagCompound getSpecialInfo() {
        if (this.specialInfo == null) {
            this.specialInfo = new NBTTagCompound();
        }
        return this.specialInfo;
    }

    public void setSpecialInfo(NBTTagCompound specialInfo) {
        this.specialInfo = specialInfo;
    }

    public ItemStack removeTopItem() {
        if (this.layers.size() > 0) {
            ItemStack removed = this.layers.remove(this.layers.size() - 1);
            ITopItemEvent topItemEvent = (ITopItemEvent)BoardEventRegistry.getTopItemEventFor(removed);
            SandwichableConfig.SandwichableEntry itemEntry = ModConfig.getSandwichConfig().findEntry(removed);
            if (itemEntry.dropItem()) {
                return topItemEvent.getDroppeditem(this.layers, removed, this.getSpecialInfo());
            }
        }
        return null;
    }

    public List<ItemStack> getLayers() {
        return this.layers;
    }

    public ItemStack getBottom() {
        return this.layers.size() > 0 ? this.layers.get(0) : null;
    }

    public ItemStack getTop() {
        return this.layers.size() > 0 ? this.layers.get(this.layers.size() - 1) : null;
    }

    public ItemStack finishSandwich() {
        if (this.layers.size() < 2 || !ModConfig.getSandwichConfig().isBread(this.getTop()) || !ModConfig.getSandwichConfig().isBread(this.getBottom())) {
            return null;
        }
        NBTTagList layersList = new NBTTagList();
        ItemStack sandwich = GameRegistry.findItemStack((String)"kitchen", (String)"sandwich", (int)1);
        for (ItemStack layer : this.layers) {
            NBTTagCompound layerCompound = new NBTTagCompound();
            layer.func_77955_b(layerCompound);
            layersList.func_74742_a((NBTBase)layerCompound);
        }
        sandwich.func_77983_a("SandwichLayers", (NBTBase)layersList);
        this.resetLayers();
        return sandwich;
    }

    public void resetLayers() {
        this.layers = new ArrayList<ItemStack>();
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.resetLayers();
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound layerCompound = list.func_150305_b(i);
            ItemStack layer = ItemStack.func_77949_a((NBTTagCompound)layerCompound);
            this.rightClicked(layer, false);
        }
        this.setSpecialInfo(compound.func_74775_l("SpecialInfo"));
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ItemStack layer : this.layers) {
            if (layer == null) continue;
            NBTTagCompound layerCompound = new NBTTagCompound();
            layer.func_77955_b(layerCompound);
            list.func_74742_a((NBTBase)layerCompound);
        }
        compound.func_74782_a("Items", (NBTBase)list);
        compound.func_74782_a("SpecialInfo", (NBTBase)this.getSpecialInfo());
    }

    @Override
    public int getNBTLevel() {
        return 1;
    }

    @Override
    public void readDataFromOldNBT(int oldLevel, int newLevel, NBTTagCompound compound) {
        this.warnNBTLevelChange(oldLevel, newLevel);
        this.readDataFromNBT(compound);
    }
}

