/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.recipe.OvenRecipes;
import dk.mrspring.kitchen.tileentity.TileEntityBase;
import dk.mrspring.kitchen.tileentity.renderer.OpeningAnimation;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityOven
extends TileEntityBase {
    ItemStack[] ovenItems = new ItemStack[4];
    int burnTime = 0;
    int itemState = 0;
    boolean isCooking = false;
    public static final int RAW = 0;
    public static final int COOKED = 1;
    public static final int BURNT = 2;
    boolean isOpen = false;
    boolean hasCoal = false;
    @SideOnly(value=Side.CLIENT)
    OpeningAnimation openingAnimation;

    public TileEntityOven() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.openingAnimation = new OpeningAnimation(0, 65, 10, this.isOpen());
        }
    }

    public boolean rightClicked(ItemStack itemStack, boolean alt) {
        if (itemStack != null) {
            if (this.isOpen()) {
                if (OvenRecipes.getCookingResult(itemStack) != null) {
                    return this.addItemStack(itemStack);
                }
                if (itemStack.func_77973_b() == Items.field_151044_h && !this.hasCoal) {
                    this.hasCoal = true;
                    --itemStack.field_77994_a;
                    this.mark();
                    return true;
                }
            }
            return false;
        }
        if (alt) {
            this.toggleOpen();
        } else if (this.isOpen()) {
            this.spawn(this.removeFirstItem());
        }
        return true;
    }

    @Override
    public void spawn(double x, double y, double z, ItemStack ... stacks) {
        super.spawn(x, y + 1.0, z, stacks);
    }

    private boolean addItemStack(ItemStack itemStack) {
        ItemStack temp = itemStack.func_77946_l();
        temp.field_77994_a = 1;
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] != null) {
                if (!itemStack.func_77969_a(this.ovenItems[i]) || this.ovenItems[i].field_77994_a >= 4) continue;
                ++this.ovenItems[i].field_77994_a;
                --itemStack.field_77994_a;
                this.mark();
                return true;
            }
            this.ovenItems[i] = itemStack.func_77946_l();
            this.ovenItems[i].field_77994_a = 1;
            --itemStack.field_77994_a;
            this.mark();
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.openingAnimation.update(this.isOpen());
        }
        if (!this.isOpen() && this.hasCoal) {
            if (!this.isCooking) {
                if (this.canCookItems()) {
                    ++this.burnTime;
                    this.isCooking = true;
                } else {
                    this.burnTime = 0;
                }
            } else {
                ++this.burnTime;
            }
        } else {
            this.burnTime = 0;
        }
        if (this.burnTime == 0) {
            this.itemState = 0;
        }
        if (this.burnTime == 400) {
            this.itemState = 1;
            this.cookItems();
            this.mark();
        }
        if (this.burnTime == 600) {
            this.itemState = 2;
            this.burnItems();
            this.mark();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public OpeningAnimation getOpeningAnimation() {
        return this.openingAnimation;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean hasCoal() {
        return this.hasCoal;
    }

    public int getItemState() {
        return this.itemState;
    }

    public ItemStack[] getOvenItems() {
        return this.ovenItems;
    }

    public boolean canCookItems() {
        boolean foundCompatible = false;
        for (ItemStack item : this.ovenItems) {
            if (item == null || OvenRecipes.getCookingResult(item) == null) continue;
            foundCompatible = true;
        }
        return foundCompatible;
    }

    public void toggleOpen() {
        if (this.isOpen()) {
            this.setClosed();
        } else {
            this.setOpen();
        }
    }

    public void setOpen() {
        this.isOpen = true;
        this.hasCoal = false;
        this.isCooking = false;
        this.mark();
    }

    public void setClosed() {
        this.isOpen = false;
        this.burnTime = 0;
        this.mark();
    }

    public void cookItems() {
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] == null || OvenRecipes.getCookingResult(this.ovenItems[i]) == null) continue;
            int stackSize = this.ovenItems[i].field_77994_a;
            this.ovenItems[i] = OvenRecipes.getCookingResult(this.ovenItems[i]);
            this.ovenItems[i].field_77994_a *= stackSize;
        }
    }

    public void burnItems() {
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] == null) continue;
            int stackSize = this.ovenItems[i].field_77994_a;
            this.ovenItems[i] = new ItemStack(KitchenItems.burnt_meat, stackSize);
        }
    }

    public ItemStack removeFirstItem() {
        for (int i = 0; i < this.ovenItems.length; ++i) {
            ItemStack stack = this.ovenItems[i];
            if (stack == null) continue;
            ItemStack copy = stack.func_77946_l();
            this.ovenItems[i] = null;
            this.mark();
            return copy;
        }
        return null;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74777_a("CookTime", (short)this.burnTime);
        compound.func_74757_a("IsOpen", this.isOpen());
        compound.func_74757_a("HasCoal", this.hasCoal);
        compound.func_74777_a("ItemState", (short)this.itemState);
        compound.func_74757_a("IsCooking", this.isCooking);
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.ovenItems.length; ++i) {
            if (this.ovenItems[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.ovenItems[i].func_77955_b(itemCompound);
            nbtTagList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbtTagList);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.burnTime = compound.func_74765_d("CookTime");
        this.isOpen = compound.func_74767_n("IsOpen");
        this.hasCoal = compound.func_74767_n("HasCoal");
        this.itemState = compound.func_74765_d("ItemState");
        this.isCooking = compound.func_74767_n("IsCooking");
        this.ovenItems = new ItemStack[4];
        NBTTagList nbtTagList = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = nbtTagList.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.ovenItems.length) continue;
            this.ovenItems[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }

    @Override
    public int getNBTLevel() {
        return 1;
    }

    @Override
    public void readDataFromOldNBT(int oldLevel, int newLevel, NBTTagCompound compound) {
        this.warnNBTLevelChange(oldLevel, newLevel);
        this.readDataFromNBT(compound);
    }

    public boolean isCooking() {
        return this.isCooking;
    }
}

