/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import dk.mrspring.kitchen.KitchenBlocks;
import dk.mrspring.kitchen.KitchenItems;
import dk.mrspring.kitchen.ModLogger;
import dk.mrspring.kitchen.pan.Ingredient;
import dk.mrspring.kitchen.tileentity.TileEntityBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityPan
extends TileEntityBase {
    Ingredient ingredient = Ingredient.EMPTY;
    int cookTime = 0;
    boolean isFunctional = true;
    boolean firstRun = true;
    final int FINISH_TIME = 300;

    public boolean rightClicked(ItemStack clicked) {
        if (this.ingredient != Ingredient.EMPTY) {
            this.spawn(this.finishItem(clicked));
            return true;
        }
        if (clicked != null) {
            return this.setIngredient(clicked);
        }
        return false;
    }

    private ItemStack[] finishItem(ItemStack clicked) {
        if (this.ingredient.canRemove(this, clicked)) {
            this.mark();
            ItemStack[] stacks = this.ingredient.onRemoved(this, clicked);
            this.ingredient = Ingredient.EMPTY;
            return stacks;
        }
        return new ItemStack[0];
    }

    private boolean setIngredient(ItemStack clicked) {
        Ingredient ingredientFromItem;
        if (this.ingredient == Ingredient.EMPTY && (ingredientFromItem = KitchenItems.valueOf(clicked.func_77973_b())) != Ingredient.EMPTY) {
            this.cookTime = 0;
            this.ingredient = ingredientFromItem;
            --clicked.field_77994_a;
            this.mark();
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (this.firstRun) {
            this.checkIsFunctional();
            this.firstRun = false;
        }
        if (this.getIngredient() != Ingredient.EMPTY && this.isFunctional) {
            if (this.cookTime <= 300) {
                ++this.cookTime;
            }
        } else {
            this.cookTime = 0;
        }
    }

    public void checkIsFunctional() {
        this.setFunctional(this.isOnOven());
    }

    public void setFunctional(boolean functional) {
        this.isFunctional = functional;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getAngle() {
        return this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
    }

    public boolean isOnOven() {
        return this.func_145831_w().func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == KitchenBlocks.oven;
    }

    public boolean isFinished() {
        return this.getCookTime() >= 300;
    }

    @Override
    public int getNBTLevel() {
        return 1;
    }

    @Override
    public void readDataFromOldNBT(int oldLevel, int newLevel, NBTTagCompound compound) {
        this.warnNBTLevelChange(oldLevel, newLevel);
        this.readDataFromNBT(compound);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Ingredient", this.getIngredient().getName());
        compound.func_74768_a("CookTime", this.getCookTime());
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        String string = compound.func_74779_i("Ingredient");
        try {
            this.ingredient = Ingredient.getIngredient(string);
        }
        catch (IllegalArgumentException e) {
            ModLogger.print(1, "There was a problem loading pan at X:" + this.field_145851_c + ", Y:" + this.field_145848_d + ", Z:" + this.field_145849_e + ", the ingredient " + string + " could not be found!");
            e.printStackTrace();
        }
        this.cookTime = compound.func_74762_e("CookTime");
    }
}

