/*
 * Decompiled with CFR 0.152.
 */
package dk.mrspring.kitchen.tileentity;

import dk.mrspring.kitchen.KitchenBlocks;
import dk.mrspring.kitchen.item.ItemSandwich;
import dk.mrspring.kitchen.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityPlate
extends TileEntityBase {
    List<ItemStack> items = new ArrayList<ItemStack>();
    boolean isFull = false;

    public boolean clicked(ItemStack stack) {
        if (stack != null) {
            if (!(this.isFull || stack.func_77973_b() instanceof ItemSandwich && this.items.size() != 0)) {
                return this.addStack(stack);
            }
        } else {
            this.spawn(this.removeTopItem());
            return true;
        }
        return false;
    }

    public boolean addStack(ItemStack stack) {
        this.mark();
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = 1;
        return this.items.add(copy);
    }

    public ItemStack removeTopItem() {
        if (!this.isEmpty()) {
            this.mark();
            int size = this.items.size();
            if (size - 1 == 0) {
                this.isFull = false;
            }
            return this.items.remove(size - 1);
        }
        return null;
    }

    public ItemStack toItemStack() {
        ItemStack plate = new ItemStack(KitchenBlocks.plate);
        NBTTagCompound plateCompound = new NBTTagCompound();
        this.writeItemsToNBT(plateCompound);
        plate.func_77983_a("PlateData", (NBTBase)plateCompound);
        return plate;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.getItems().size() == 0;
    }

    public void clear() {
        this.getItems().clear();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        this.writeItemsToNBT(compound);
        compound.func_74757_a("IsFull", this.isFull);
    }

    public void writeItemsToNBT(NBTTagCompound compound) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack item : this.items) {
            if (item == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound = item.func_77955_b(itemCompound);
            itemList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.readItemsFromNBT(compound);
        this.isFull = compound.func_74767_n("IsFull");
    }

    public void readItemsFromNBT(NBTTagCompound compound) {
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            if (itemList.func_150305_b(i) == null) continue;
            NBTTagCompound item = itemList.func_150305_b(i);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)item);
            this.items.add(itemStack);
        }
    }

    @Override
    public int getNBTLevel() {
        return 1;
    }

    @Override
    public void readDataFromOldNBT(int oldLevel, int newLevel, NBTTagCompound compound) {
        this.warnNBTLevelChange(oldLevel, newLevel);
        this.readDataFromNBT(compound);
    }
}

