/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class DropdownButtonElement<T extends GuiScreen>
extends Element<T> {
    private final List<String> entries;
    private String text;
    private boolean dropped;
    private Function<DropdownButtonElement<T>, Boolean> function;
    private int dropdownWidth;
    private String selected;

    public DropdownButtonElement(T gui, String text, float posX, float posY, int width, int height, List<String> entries, Function<DropdownButtonElement<T>, Boolean> function) {
        super(gui, posX, posY, width, height);
        this.text = text;
        this.function = function;
        this.entries = entries;
        for (String entry : entries) {
            int entryWidth = ((GuiScreen)gui).field_146297_k.field_71466_p.func_78256_a(entry) + 5;
            if (entryWidth <= this.dropdownWidth) continue;
            this.dropdownWidth = entryWidth;
        }
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), this.isEnabled() && (this.isSelected(mouseX, mouseY) || this.dropped) ? this.getColorScheme().getPrimaryColor() : this.getColorScheme().getSecondaryColor());
        FontRenderer fontRenderer = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p;
        this.drawString(this.text, this.getPosX() + (float)(this.getWidth() / 2) - (float)(fontRenderer.func_78256_a(this.text) / 2), this.getPosY() + (float)(this.getHeight() / 2) - (float)(fontRenderer.field_78288_b / 2), LLibrary.CONFIG.getTextColor(), false);
        if (this.dropped) {
            this.drawRectangle(this.getPosX(), this.getPosY() + (float)this.getHeight(), this.dropdownWidth, this.entries.size() * 12, this.getColorScheme().getSecondaryColor());
            float y = this.getPosY() + (float)this.getHeight() + 2.0f;
            for (String entry : this.entries) {
                if (this.isEntrySelected(mouseX, mouseY, y)) {
                    this.drawRectangle(this.getPosX(), y - 2.0f, this.dropdownWidth, 12.0, this.getColorScheme().getPrimaryColor());
                }
                this.drawString(entry, this.getPosX() + 3.0f, y, LLibrary.CONFIG.getTextColor(), false);
                y += 12.0f;
            }
        }
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        this.selected = null;
        if (this.isSelected(mouseX, mouseY)) {
            this.dropped = !this.dropped;
            ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("gui.button.press")));
            return true;
        }
        if (this.dropped) {
            float y = this.getPosY() + (float)this.getHeight() + 2.0f;
            for (String entry : this.entries) {
                if (this.isEntrySelected(mouseX, mouseY, y)) {
                    this.selected = entry;
                    if (this.function.apply(this).booleanValue()) {
                        ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("gui.button.press")));
                        break;
                    }
                }
                y += 12.0f;
            }
        }
        this.dropped = false;
        return false;
    }

    public String getSelected() {
        return this.selected;
    }

    private boolean isEntrySelected(float mouseX, float mouseY, float y) {
        float x = this.getPosX() + 3.0f;
        return mouseX >= x && mouseX <= x + (float)this.dropdownWidth && mouseY >= y && mouseY <= y + 12.0f;
    }
}

