/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class QubbleAnimationAction {
    private String cuboid;
    private Action action;
    private float valueX;
    private float valueY;
    private float valueZ;

    private QubbleAnimationAction() {
    }

    public static QubbleAnimationAction create(String cuboid, Action action) {
        QubbleAnimationAction animation = new QubbleAnimationAction();
        animation.setCuboid(cuboid);
        animation.setAction(action);
        return animation;
    }

    public static QubbleAnimationAction deserialize(NBTTagCompound compound) {
        QubbleAnimationAction animation = new QubbleAnimationAction();
        animation.deserializeNBT(compound);
        return animation;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cuboid", this.cuboid);
        compound.func_74778_a("action", this.action.name());
        NBTTagCompound valueTag = new NBTTagCompound();
        valueTag.func_74776_a("x", this.valueX);
        valueTag.func_74776_a("y", this.valueY);
        valueTag.func_74776_a("z", this.valueZ);
        compound.func_74782_a("value", (NBTBase)valueTag);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.cuboid = compound.func_74779_i("cuboid");
        this.action = Action.valueOf(compound.func_74779_i("action"));
        NBTTagCompound valueTag = compound.func_74775_l("value");
        this.valueX = valueTag.func_74760_g("x");
        this.valueY = valueTag.func_74760_g("y");
        this.valueZ = valueTag.func_74760_g("z");
    }

    public String getCuboid() {
        return this.cuboid;
    }

    public void setCuboid(String cuboid) {
        this.cuboid = cuboid;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public float getValueX() {
        return this.valueX;
    }

    public float getValueY() {
        return this.valueY;
    }

    public float getValueZ() {
        return this.valueZ;
    }

    public void setValue(float x, float y, float z) {
        this.valueX = x;
        this.valueY = y;
        this.valueZ = z;
    }

    public QubbleAnimationAction copy() {
        QubbleAnimationAction animation = QubbleAnimationAction.create(this.getCuboid(), this.getAction());
        animation.setValue(this.getValueX(), this.getValueY(), this.getValueZ());
        return animation;
    }

    public static enum Action {
        ROTATE,
        MOVE;

    }
}

