/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.model.qubble;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.client.model.qubble.QubbleAnimationAction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class QubbleAnimationKeyframe {
    private int duration;
    private Type type;
    private List<QubbleAnimationAction> actions = new ArrayList<QubbleAnimationAction>();

    private QubbleAnimationKeyframe() {
    }

    public static QubbleAnimationKeyframe create(int duration, Type type) {
        QubbleAnimationKeyframe keyframe = new QubbleAnimationKeyframe();
        keyframe.setDuration(duration);
        keyframe.setType(type);
        return keyframe;
    }

    public static QubbleAnimationKeyframe deserialize(NBTTagCompound compound) {
        QubbleAnimationKeyframe keyframe = new QubbleAnimationKeyframe();
        keyframe.deserializeNBT(compound);
        return keyframe;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("duration", this.duration);
        compound.func_74778_a("type", this.type.name());
        NBTTagList actionsTag = new NBTTagList();
        for (QubbleAnimationAction action : this.actions) {
            actionsTag.func_74742_a((NBTBase)action.serializeNBT());
        }
        compound.func_74782_a("actions", (NBTBase)actionsTag);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.duration = compound.func_74762_e("duration");
        this.type = Type.valueOf(compound.func_74779_i("type"));
        NBTTagList actionsTag = compound.func_150295_c("actions", 10);
        for (int i = 0; i < actionsTag.func_74745_c(); ++i) {
            this.actions.add(QubbleAnimationAction.deserialize(actionsTag.func_150305_b(i)));
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<QubbleAnimationAction> getActions() {
        return this.actions;
    }

    public QubbleAnimationKeyframe copy() {
        QubbleAnimationKeyframe keyframe = QubbleAnimationKeyframe.create(this.getDuration(), this.getType());
        keyframe.getActions().addAll(this.getActions().stream().map(QubbleAnimationAction::copy).collect(Collectors.toList()));
        return keyframe;
    }

    public static enum Type {
        DYNAMIC,
        STATIC,
        RESET;

    }
}

