/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.ilexiconn.llibrary.server.structure.BlockCoords;
import net.ilexiconn.llibrary.server.structure.BlockList;
import net.ilexiconn.llibrary.server.structure.BlockState;
import net.ilexiconn.llibrary.server.structure.ComponentInfo;
import net.ilexiconn.llibrary.server.structure.RotationAngle;
import net.ilexiconn.llibrary.server.structure.StructureGenerator;
import net.ilexiconn.llibrary.server.structure.rule.FixedRule;
import net.ilexiconn.llibrary.server.structure.rule.RepeatRule;
import net.ilexiconn.llibrary.server.util.Tuple3;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class StructureBuilder
extends StructureGenerator {
    private final HashMap<BlockCoords, BlockList> blocks = Maps.newHashMap();
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private List<RepeatRule> repeats = Lists.newArrayList();
    private List<ComponentInfo> components = Lists.newArrayList();
    private ComponentInfo currentLayer;

    @Override
    public void generate(World world, int x, int y, int z, Random random) {
        BlockCoords pos = new BlockCoords();
        for (ComponentInfo layer : this.components) {
            for (RepeatRule rule : layer.repeats) {
                rule.reset(world, random, pos);
            }
        }
        for (ComponentInfo layer : this.components) {
            pos.x = x;
            pos.y = y;
            pos.z = z;
            for (RepeatRule rule : layer.repeats) {
                rule.init(world, random, pos);
                while (rule.continueRepeating(world, random, pos)) {
                    for (Map.Entry<BlockCoords, BlockList> e : layer.blocks.entrySet()) {
                        BlockCoords coords = e.getKey();
                        int blockX = coords.x + pos.x;
                        int blockY = coords.y + pos.y;
                        int blockZ = coords.z + pos.z;
                        BlockState state = e.getValue().getRandom(random);
                        world.func_147449_b(blockX, blockY, blockZ, state.getBlock());
                        world.func_72921_c(blockX, blockY, blockZ, state.getMeta(), 2);
                    }
                    rule.repeat(world, random, pos);
                }
            }
        }
    }

    @Override
    public StructureGenerator rotateClockwise(RotationAngle angle) {
        StructureBuilder copy = new StructureBuilder();
        float radAngle = 0.0f;
        switch (angle) {
            case DEGREES_180: {
                return this.rotateClockwise(RotationAngle.DEGREES_90).rotateClockwise(RotationAngle.DEGREES_90);
            }
            case DEGREES_90: {
                radAngle = 1.5707964f;
                break;
            }
            case DEGREES_270: {
                radAngle = 4.712389f;
            }
        }
        for (ComponentInfo oldComp : this.components) {
            ComponentInfo newComp = new ComponentInfo();
            newComp.repeats.addAll(oldComp.repeats);
            newComp.facing = oldComp.facing;
            for (int i = 0; i < angle.getTurnsCount(); ++i) {
                newComp.facing = StructureBuilder.getNextClockwise(newComp.facing);
            }
            HashMap<BlockCoords, BlockList> blocks = newComp.blocks;
            Tuple3<Integer, Integer, Integer> minCoords = this.mins(oldComp.blocks);
            Tuple3<Integer, Integer, Integer> maxCoords = this.maxs(oldComp.blocks);
            int width = maxCoords.getA() - minCoords.getA();
            int depth = maxCoords.getC() - minCoords.getC();
            float midX = (float)width / 2.0f + (float)minCoords.getA().intValue();
            float midZ = (float)depth / 2.0f + (float)minCoords.getC().intValue();
            for (BlockCoords coords : oldComp.blocks.keySet()) {
                float angleToCenter = (float)Math.atan2((float)coords.z - midZ, (float)coords.x - midX);
                float dx = midX - (float)coords.x;
                float dz = midZ - (float)coords.z;
                float distToCenter = (float)Math.sqrt(dx * dx + dz * dz);
                float nangle = radAngle + angleToCenter;
                float newX = (float)Math.cos(nangle) * distToCenter;
                float newZ = (float)Math.sin(nangle) * distToCenter;
                BlockCoords newCoords = new BlockCoords((int)Math.floor(newX + midX), coords.y, (int)Math.floor(newZ + midZ));
                BlockList newList = oldComp.blocks.get(coords).copy();
                blocks.put(newCoords, newList);
            }
            copy.components.add(newComp);
        }
        return copy;
    }

    private Tuple3<Integer, Integer, Integer> maxs(HashMap<BlockCoords, BlockList> blocks) {
        Tuple3<Integer, Integer, Integer> result = new Tuple3<Integer, Integer, Integer>();
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockCoords coords : blocks.keySet()) {
            int x = coords.x;
            int y = coords.y;
            int z = coords.z;
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        result.set(maxX, maxY, maxZ);
        return result;
    }

    private Tuple3<Integer, Integer, Integer> mins(HashMap<BlockCoords, BlockList> blocks) {
        Tuple3<Integer, Integer, Integer> result = new Tuple3<Integer, Integer, Integer>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockCoords coords : blocks.keySet()) {
            int x = coords.x;
            int y = coords.y;
            int z = coords.z;
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z >= minZ) continue;
            minZ = z;
        }
        result.set(minX, minY, minZ);
        return result;
    }

    @Override
    public StructureGenerator rotateTowards(EnumFacing facing) {
        return null;
    }

    public StructureBuilder startComponent() {
        this.currentLayer = new ComponentInfo();
        this.blocks.clear();
        this.repeats.clear();
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        return this;
    }

    public StructureBuilder setOrientation(EnumFacing facing) {
        this.currentLayer.facing = facing;
        return this;
    }

    public StructureBuilder endComponent() {
        this.currentLayer.blocks.putAll(this.blocks);
        this.currentLayer.repeats.addAll(this.repeats);
        this.components.add(this.currentLayer);
        return this;
    }

    public StructureBuilder setOffset(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public StructureBuilder translate(int x, int y, int z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
        return this;
    }

    public StructureBuilder setBlock(int x, int y, int z, Block block) {
        return this.setBlock(x, y, z, BlockState.create(block));
    }

    public StructureBuilder setBlock(int x, int y, int z, BlockState block) {
        return this.setBlock(x, y, z, new BlockList(block));
    }

    public StructureBuilder setBlock(int x, int y, int z, BlockList list) {
        this.blocks.put(new BlockCoords(x + this.offsetX, y + this.offsetY, z + this.offsetZ), list);
        return this;
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, BlockState block) {
        return this.cube(startX, startY, startZ, width, height, depth, new BlockList(block));
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        if (depth > 1) {
            this.fillCube(startX, startY, startZ, width, height, 1, list);
            this.fillCube(startX, startY, startZ + depth - 1, width, height, 1, list);
        }
        if (width > 1) {
            this.fillCube(startX, startY, startZ, 1, height, depth, list);
            this.fillCube(startX + width - 1, startY, startZ, 1, height, depth, list);
        }
        if (height > 1) {
            this.fillCube(startX, startY, startZ, width, 1, depth, list);
            this.fillCube(startX, startY + height - 1, startZ, width, 1, depth, list);
        }
        return this;
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, BlockState block) {
        return this.fillCube(startX, startY, startZ, width, height, depth, new BlockList(block));
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        for (int x = startX; x < startX + width; ++x) {
            for (int y = startY; y < startY + height; ++y) {
                for (int z = startZ; z < startZ + depth; ++z) {
                    this.setBlock(x, y, z, list);
                }
            }
        }
        return this;
    }

    public StructureBuilder repeat(int spacingX, int spacingY, int spacingZ, int times) {
        return this.repeat(spacingX, spacingY, spacingZ, new FixedRule(times));
    }

    public StructureBuilder repeat(int spacingX, int spacingY, int spacingZ, RepeatRule repeatRule) {
        repeatRule.setSpacing(spacingX, spacingY, spacingZ);
        return this.addBakedRepeatRule(repeatRule);
    }

    public StructureBuilder addBakedRepeatRule(RepeatRule repeatRule) {
        this.repeats.add(repeatRule);
        return this;
    }

    public StructureBuilder cube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.cube(startX, startY, startZ, width, height, depth, BlockState.create(block));
    }

    public StructureBuilder fillCube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.fillCube(startX, startY, startZ, width, height, depth, BlockState.create(block));
    }

    public StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, Block block) {
        return this.wireCube(startX, startY, startZ, width, height, depth, BlockState.create(block));
    }

    public StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, BlockState state) {
        return this.wireCube(startX, startY, startZ, width, height, depth, new BlockList(state));
    }

    private StructureBuilder wireCube(int startX, int startY, int startZ, int width, int height, int depth, BlockList list) {
        this.fillCube(startX, startY, startZ, 1, height, 1, list);
        this.fillCube(startX + width - 1, startY, startZ, 1, height, 1, list);
        this.fillCube(startX + width - 1, startY, startZ + depth - 1, 1, height, 1, list);
        this.fillCube(startX, startY, startZ + depth - 1, 1, height, 1, list);
        this.fillCube(startX, startY, startZ, width, 1, 1, list);
        this.fillCube(startX, startY + height, startZ, width, 1, 1, list);
        this.fillCube(startX, startY, startZ + depth - 1, width, 1, 1, list);
        this.fillCube(startX, startY + height, startZ + depth - 1, width, 1, 1, list);
        this.fillCube(startX, startY, startZ, 1, 1, depth, list);
        this.fillCube(startX, startY + height, startZ, 1, 1, depth, list);
        this.fillCube(startX + width - 1, startY, startZ, 1, 1, depth, list);
        this.fillCube(startX + width - 1, startY + height, startZ, 1, 1, depth, list);
        return this;
    }
}

