/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.util;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.crash.CrashReport;

public class WebUtils {
    public static final String PASTEBIN_URL_PREFIX = "http://pastebin.com/raw.php?i=";

    public static String readPastebin(String pasteID) {
        return WebUtils.readURL(PASTEBIN_URL_PREFIX + pasteID);
    }

    public static List<String> readPastebinAsList(String pasteID) {
        return WebUtils.readURLAsList(PASTEBIN_URL_PREFIX + pasteID);
    }

    public static String readURL(String url) {
        try {
            String currentLine;
            String text = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((currentLine = reader.readLine()) != null) {
                text = text + currentLine + "\r\n";
            }
            reader.close();
            return text;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static List<String> readURLAsList(String url) {
        try {
            String currentLine;
            ArrayList text = Lists.newArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((currentLine = reader.readLine()) != null) {
                text.add(currentLine);
            }
            reader.close();
            return text;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static BufferedImage downloadImage(String url) {
        try {
            return ImageIO.read(new BufferedInputStream(new URL(url).openStream()));
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }
}

