/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import com.rwtema.extrautils.modintegration.TConTextureResourcePackBedrockium;
import com.rwtema.extrautils.texture.TextureDerived;
import java.awt.image.BufferedImage;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.MathHelper;

public class TextureBedrockLava
extends TextureDerived {
    public TextureBedrockLava(String p_i1282_1_, String baseIcon) {
        super(p_i1282_1_, baseIcon, TextureDerived.TextureMapType.BLOCK);
    }

    @Override
    public BufferedImage processImage(BufferedImage image, AnimationMetadataSection animationmetadatasection) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] pixels = new int[h * w];
        image.getRGB(0, 0, w, h, pixels, 0, w);
        double mean = 0.0;
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = this.getLuminosity(pixels[i]);
            mean += (double)pixels[i];
        }
        mean /= (double)pixels.length;
        BufferedImage bedrockImage = TConTextureResourcePackBedrockium.getBedrockImage();
        for (int i = 0; i < pixels.length; ++i) {
            int x = i % w;
            int y = (i - x) / w % w;
            int sn = (i - x) / w / w;
            int dx = x * bedrockImage.getWidth() / w;
            int dy = y * bedrockImage.getHeight() / w;
            int col = bedrockImage.getRGB(dx, dy);
            double f = (double)pixels[i] / mean;
            int r = this.clamp((double)this.rgb.getRed(col) * f);
            int g = this.clamp((double)this.rgb.getGreen(col) * f);
            int b = this.clamp((double)this.rgb.getBlue(col) * f);
            pixels[i] = 0xFF000000 | r << 16 | g << 8 | b;
        }
        image.setRGB(0, 0, w, h, pixels, 0, w);
        return image;
    }

    private int clamp(double v) {
        return MathHelper.func_76125_a((int)((int)v), (int)0, (int)255);
    }
}

