/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import extrabiomes.blocks.BlockCropBasic;
import extrabiomes.blocks.ICropType;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockCropRegrow
extends BlockCropBasic {
    public static final int REGROW_META = 4;

    public BlockCropRegrow(CropType type) {
        super(type);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (meta >= 7) {
            ret.add(new ItemStack(this.getCropItem(), 1, 0));
        } else {
            ret.add(this.getSeedItem());
        }
        return ret;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) >= 4) {
            return 0.5f;
        }
        return this.field_149782_v;
    }

    public boolean doHarvest(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return true;
        }
        int growth = world.func_72805_g(x, y, z);
        if (growth >= 7) {
            EntityItem drop = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, new ItemStack(this.getCropItem(), 1, 0));
            world.func_72838_d((Entity)drop);
            drop.func_70100_b_(player);
            this.doRegrow(world, x, y, z, growth);
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        return this.doHarvest(world, x, y, z, player);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.doHarvest(world, x, y, z, player);
    }

    public void doRegrow(World world, int x, int y, int z, int meta) {
        int newMeta = meta > 4 ? 4 : meta;
        world.func_147465_d(x, y, z, (Block)this, newMeta, 3);
    }

    public static enum CropType implements ICropType
    {
        STRAWBERRY(1);

        private ArrayList<IIcon> IIcons;
        private ItemStack seed;
        private Item crop;
        private final int renderType;

        private CropType(Integer renderType) {
            this.renderType = renderType == null ? 6 : renderType;
        }

        @Override
        public IIcon getStageIIcon(int stage) {
            return this.IIcons.get(stage);
        }

        @Override
        public void setStageIIcons(ArrayList<IIcon> IIcons) {
            this.IIcons = IIcons;
        }

        @Override
        public ItemStack getSeedItem() {
            return this.seed;
        }

        @Override
        public Item getCropItem() {
            return this.crop;
        }

        @Override
        public void setSeedItem(ItemStack seed) {
            this.seed = seed;
        }

        @Override
        public void setCropItem(Item crop) {
            this.crop = crop;
        }

        @Override
        public int getRenderType() {
            return this.renderType;
        }
    }
}

