/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.lib.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockMoreLeaves
extends BlockLeavesBase
implements IShearable {
    private static final int METADATA_BITMASK = 3;
    private static final int METADATA_USERPLACEDBIT = 4;
    private static final int METADATA_DECAYBIT = 8;
    private static final int METADATA_CLEARDECAYBIT = -9;
    int[] adjacentTreeBlocks;
    private IIcon[] textures = new IIcon[]{null, null, null, null, null, null, null, null, null, null, null, null};

    private static int calcSmoothedBiomeFoliageColor(IBlockAccess iBlockAccess, int x, int z) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int z1 = -1; z1 <= 1; ++z1) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                int foliageColor = iBlockAccess.func_72807_a(x + x1, z + z1).func_150571_c(x + x1, 96, z + z1);
                red += (foliageColor & 0xFF0000) >> 16;
                green += (foliageColor & 0xFF00) >> 8;
                blue += foliageColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private static int clearDecayOnMetadata(int metadata) {
        return metadata & 0xFFFFFFF7;
    }

    private static boolean isDecaying(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isUserPlaced(int metadata) {
        return (metadata & 4) != 0;
    }

    private static int setDecayOnMetadata(int metadata) {
        return metadata | 8;
    }

    private static int unmarkedMetadata(int metadata) {
        return metadata & 3;
    }

    public BlockMoreLeaves(Material material, boolean useFastGraphics) {
        super(material, useFastGraphics);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures[0] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavessakurafancy");
        this.textures[1] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "leavessakurafast");
        this.textures[8] = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "better_leavessakura");
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, BlockMoreLeaves.setDecayOnMetadata(world.func_72805_g(x, y, z)), 3);
    }

    public void func_149749_a(World world, int x, int y, int z, Block _block, int metadata) {
        boolean leafDecayRadius = true;
        int chuckCheckRadius = 2;
        if (!world.func_72904_c(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2)) {
            return;
        }
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -1; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    Block block = world.func_147439_a(x + x1, y + y1, z + z1);
                    if (block == null) continue;
                    block.beginLeavesDecay(world, x + x1, y + y1, z + z1);
                }
            }
        }
    }

    public int func_149720_d(IBlockAccess iBlockAccess, int x, int y, int z) {
        int metadata = BlockMoreLeaves.unmarkedMetadata(iBlockAccess.func_72805_g(x, y, z));
        return this.func_149741_i(metadata);
    }

    public int func_149692_a(int metadata) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingMetadata() : 0;
    }

    private void doSaplingDrop(World world, int x, int y, int z, int metadata, int par7) {
        Item itemDropped = this.func_149650_a(metadata, world.field_73012_v, par7);
        int damageDropped = this.func_149692_a(metadata);
        this.func_149642_a(world, x, y, z, new ItemStack(itemDropped, 1, damageDropped));
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int par7) {
        this.leafTypeDropper((IBlockAccess)world, world, x, y, z, metadata, par7);
    }

    private void leafTypeDropper(IBlockAccess iBlockAccess, World world, int x, int y, int z, int metadata, int par7) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(20) == 0) {
            this.doSaplingDrop(world, x, y, z, metadata, par7);
        }
    }

    public int func_149635_D() {
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.textures[BlockMoreLeaves.unmarkedMetadata(metadata) * 2 + (!this.func_149662_c() ? 0 : 1)];
    }

    public IIcon getIconBetterLeaves(int metadata, float randomIndex) {
        return this.textures[8 + BlockMoreLeaves.unmarkedMetadata(metadata)];
    }

    public IIcon getIconFallingLeaves(int metadata) {
        return this.textures[BlockMoreLeaves.unmarkedMetadata(metadata) * 2 + 1];
    }

    public float getSpawnChanceFallingLeaves(int metadata) {
        return 0.01f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149643_k(World world, int x, int y, int z) {
        return BlockMoreLeaves.unmarkedMetadata(world.func_72805_g(x, y, z));
    }

    public int func_149741_i(int metadata) {
        metadata = BlockMoreLeaves.unmarkedMetadata(metadata);
        switch (metadata) {
            default: 
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (BlockType blockType : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, blockType.metadata()));
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int md) {
        super.func_149636_a(world, player, x, y, z, md);
    }

    public Item func_149650_a(int metadata, Random rand, int par3) {
        Optional type = Optional.fromNullable((Object)((Object)BlockType.fromMetadata(metadata)));
        return type.isPresent() ? ((BlockType)((Object)type.get())).getSaplingItem() : Item.func_150898_a((Block)Blocks.field_150345_g);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.beginLeavesDecay(world, x, y, z);
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockMoreLeaves.unmarkedMetadata(world.func_72805_g(x, y, z))));
        return ret;
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }

    public boolean func_149646_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        this.field_150121_P = !Blocks.field_150362_t.func_149662_c();
        return super.func_149646_a(par1iBlockAccess, par2, par3, par4, par5);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockMoreLeaves.isUserPlaced(metadata) || !BlockMoreLeaves.isDecaying(metadata)) {
            return;
        }
        int rangeWood = 8;
        int rangeCheckChunk = 9;
        int var9 = 32;
        int var10 = 1024;
        int var11 = 16;
        int leafRange = 10;
        if (this.adjacentTreeBlocks == null) {
            this.adjacentTreeBlocks = new int[32768];
        }
        if (world.func_72904_c(x - 9, y - 9, z - 9, x + 9, y + 9, z + 9)) {
            int var14;
            int var13;
            int var12;
            for (var12 = -8; var12 <= 8; ++var12) {
                for (var13 = -8; var13 <= 8; ++var13) {
                    for (var14 = -8; var14 <= 8; ++var14) {
                        Block block = world.func_147439_a(x + var12, y + var13, z + var14);
                        this.adjacentTreeBlocks[(var12 + 16) * 1024 + (var13 + 16) * 32 + var14 + 16] = block != null && block.canSustainLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? -2 : -1);
                    }
                }
            }
            for (var12 = 1; var12 <= 10; ++var12) {
                for (var13 = -8; var13 <= 8; ++var13) {
                    for (var14 = -8; var14 <= 8; ++var14) {
                        for (int var15 = -8; var15 <= 8; ++var15) {
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16] != var12 - 1) continue;
                            if (this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 - 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16 + 1) * 1024 + (var14 + 16) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 - 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16 + 1) * 32 + var15 + 16] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] == -2) {
                                this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 - 1] = var12;
                            }
                            if (this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] != -2) continue;
                            this.adjacentTreeBlocks[(var13 + 16) * 1024 + (var14 + 16) * 32 + var15 + 16 + 1] = var12;
                        }
                    }
                }
            }
        }
        if (this.adjacentTreeBlocks[16912] >= 0) {
            world.func_72921_c(x, y, z, BlockMoreLeaves.clearDecayOnMetadata(metadata), 3);
        } else {
            this.removeLeaves(world, x, y, z);
        }
    }

    public static enum BlockType {
        SAKURA_BLOSSOM(0);

        private final int metadata;
        private ItemStack sapling = new ItemStack(Blocks.field_150345_g);
        private static boolean loadedCustomBlocks;

        static BlockType fromMetadata(int metadata) {
            metadata = BlockMoreLeaves.unmarkedMetadata(metadata);
            for (BlockType type : BlockType.values()) {
                if (type.metadata() != metadata) continue;
                return type;
            }
            return null;
        }

        private static void loadCustomBlocks() {
            if (Element.SAPLING_SAKURA_BLOSSOM.isPresent()) {
                BlockType.SAKURA_BLOSSOM.sapling = Element.SAPLING_SAKURA_BLOSSOM.get();
            }
            loadedCustomBlocks = true;
        }

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        Item getSaplingItem() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77973_b();
        }

        Block getSaplingBlock() {
            return Block.func_149634_a((Item)this.getSaplingItem());
        }

        int getSaplingMetadata() {
            if (!loadedCustomBlocks) {
                BlockType.loadCustomBlocks();
            }
            return this.sapling.func_77960_j();
        }

        public int metadata() {
            return this.metadata;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

