/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.events.GetBiomeIDEvent;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.LegendOakGenerator;
import extrabiomes.module.summa.worldgen.MarshGenerator;
import extrabiomes.module.summa.worldgen.MountainDesertGenerator;
import extrabiomes.module.summa.worldgen.MountainRidgeGenerator;
import extrabiomes.module.summa.worldgen.VanillaFloraGenerator;
import extrabiomes.utility.EnhancedConfiguration;
import java.util.Locale;
import java.util.Set;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;

public enum BiomeHandler {
    INSTANCE;


    public static void enableBiomes() {
        Set<WorldType> worldTypes = BiomeHelper.discoverWorldTypes();
        for (BiomeSettings setting : BiomeSettings.values()) {
            Optional<? extends BiomeGenBase> biome = setting.getBiome();
            if (!setting.isVanilla()) {
                if (setting.isEnabled() && biome.isPresent()) {
                    BiomeHelper.enableBiome(worldTypes, (BiomeGenBase)biome.get());
                } else {
                    LogHelper.fine("Custom biome %s disabled.", setting.toString());
                }
            } else if (!setting.isEnabled()) {
                BiomeGenBase bgb = BiomeHelper.settingToBiomeGenBase(setting);
                Extrabiomes.proxy.removeBiome(bgb);
                LogHelper.fine("Vanilla biome %s disabled.", bgb.toString());
            }
            if (!setting.isEnabled() || !setting.allowVillages() || !biome.isPresent()) continue;
            BiomeManager.addVillageBiome((BiomeGenBase)((BiomeGenBase)biome.get()), (boolean)true);
            LogHelper.fine("Village spawning enabled for custom biome %s.", setting.toString());
        }
    }

    public static void init() throws Exception {
        for (BiomeSettings biome : BiomeSettings.values()) {
            if (biome.getID() <= 0 || !biome.isEnabled()) continue;
            BiomeHelper.createBiome(biome);
            biome.postLoad();
        }
        Api.getExtrabiomesXLEventBus().register((Object)INSTANCE);
    }

    public static void registerWorldGenerators(EnhancedConfiguration config) {
        if (BiomeSettings.MARSH.isEnabled() && BiomeSettings.MARSH.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MarshGenerator());
        }
        if (BiomeSettings.MOUNTAINDESERT.isEnabled() && BiomeSettings.MOUNTAINDESERT.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainDesertGenerator());
        }
        if (BiomeSettings.MOUNTAINRIDGE.isEnabled() && BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainRidgeGenerator());
        }
        Extrabiomes.proxy.registerWorldGenerator(new VanillaFloraGenerator());
        if (config.get("general", "GenerateLegendOaks", true).getBoolean()) {
            Extrabiomes.proxy.registerWorldGenerator(new LegendOakGenerator());
        }
    }

    @SubscribeEvent
    public void handleBiomeIDRequestsFromAPI(GetBiomeIDEvent event) {
        Optional settings = Optional.fromNullable((Object)((Object)BiomeSettings.valueOf(event.targetBiome.toUpperCase(Locale.ENGLISH))));
        if (settings.isPresent()) {
            event.biomeID = ((BiomeSettings)((Object)settings.get())).getID();
        }
    }
}

