/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import extrabiomes.Extrabiomes;
import extrabiomes.blocks.BlockAutumnLeaves;
import extrabiomes.blocks.BlockCatTail;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.blocks.BlockCustomLog;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockCustomTallGrass;
import extrabiomes.blocks.BlockCustomVine;
import extrabiomes.blocks.BlockGreenLeaves;
import extrabiomes.blocks.BlockKneeLog;
import extrabiomes.blocks.BlockLeafPile;
import extrabiomes.blocks.BlockMiniLog;
import extrabiomes.blocks.BlockMoreLeaves;
import extrabiomes.blocks.BlockNewLeaves;
import extrabiomes.blocks.BlockNewLog;
import extrabiomes.blocks.BlockNewQuarterLog;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.blocks.BlockQuarterLog;
import extrabiomes.blocks.BlockRedRock;
import extrabiomes.blocks.BlockWaterPlant;
import extrabiomes.blocks.GenericTerrainBlock;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.handlers.SaplingBonemealEventHandler;
import extrabiomes.handlers.SaplingBonemealNewEventHandler;
import extrabiomes.handlers.SaplingFuelHandler;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.items.ItemBlockWaterPlant;
import extrabiomes.items.ItemCatTail;
import extrabiomes.items.ItemCustomGreenLeaves;
import extrabiomes.items.ItemCustomLeaves;
import extrabiomes.items.ItemCustomMiniLog;
import extrabiomes.items.ItemCustomMoreLeaves;
import extrabiomes.items.ItemCustomNewLeaves;
import extrabiomes.items.ItemFlower;
import extrabiomes.items.ItemGrass;
import extrabiomes.items.ItemKneeLog;
import extrabiomes.items.ItemNewQuarterLog;
import extrabiomes.items.ItemNewSapling;
import extrabiomes.items.ItemOldQuarterLog;
import extrabiomes.items.ItemRedRock;
import extrabiomes.items.ItemSapling;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.summa.worldgen.CatTailGenerator;
import extrabiomes.module.summa.worldgen.EelGrassGenerator;
import extrabiomes.module.summa.worldgen.FlowerGenerator;
import extrabiomes.module.summa.worldgen.LeafPileGenerator;
import extrabiomes.module.summa.worldgen.VineGenerator;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.renderers.RenderKneeLog;
import extrabiomes.renderers.RenderMiniLog;
import extrabiomes.renderers.RenderNewQuarterLog;
import extrabiomes.renderers.RenderQuarterLog;
import extrabiomes.subblocks.SubBlockWaterPlant;
import extrabiomes.utility.MultiItemBlock;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class BlockHandler {
    private static void createAutumnLeaves() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.AUTUMNLEAVES.getEnabled()) {
            return;
        }
        BlockAutumnLeaves block = new BlockAutumnLeaves(3, Material.field_151584_j, false);
        block.func_149663_c("extrabiomes.leaves").func_149675_a(true).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomLeaves.class, "leaves_1");
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 30, 60);
        Element.LEAVES_AUTUMN_BROWN.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.UMBER.metadata()));
        Element.LEAVES_AUTUMN_ORANGE.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.GOLDENROD.metadata()));
        Element.LEAVES_AUTUMN_PURPLE.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.VERMILLION.metadata()));
        Element.LEAVES_AUTUMN_YELLOW.set(new ItemStack((Block)block, 1, BlockAutumnLeaves.BlockType.CITRINE.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    public static void createBlocks() throws Exception {
        BlockHandler.createAutumnLeaves();
        BlockHandler.createCattail();
        BlockHandler.createCrackedSand();
        BlockHandler.createFlowers();
        BlockHandler.createGrass();
        BlockHandler.createGreenLeaves();
        BlockHandler.createNewLeaves();
        BlockHandler.createMoreLeaves();
        BlockHandler.createLeafPile();
        BlockHandler.createRedRock();
        BlockHandler.createSapling();
        BlockHandler.createNewSapling();
        BlockHandler.createLogs();
        BlockHandler.createVines();
        BlockHandler.createWaterPlants();
    }

    private static void createWaterPlants() throws Exception {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.WATERPLANT.getEnabled()) {
            return;
        }
        BlockWaterPlant waterPlantBlock = new BlockWaterPlant(BlockSettings.WATERPLANT, "waterPlant");
        waterPlantBlock.func_149663_c("extrabiomes.waterplant").func_149711_c(0.01f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        waterPlantBlock.registerSubBlock(new SubBlockWaterPlant("eelgrass").addPlaceableBlock((Block)Blocks.field_150349_c).addPlaceableBlock((Block)Blocks.field_150354_m).addPlaceableBlock(Blocks.field_150351_n).addPlaceableBlock(Blocks.field_150435_aG), 0);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(waterPlantBlock, ItemBlockWaterPlant.class, "waterplant1");
        Element.WATERPLANT.set(new ItemStack((Block)waterPlantBlock, 1, 0));
        proxy.registerWorldGenerator(new EelGrassGenerator(waterPlantBlock, 0));
    }

    private static void createCattail() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.CATTAIL.getEnabled()) {
            return;
        }
        BlockCatTail block = new BlockCatTail(79, Material.field_151585_k);
        block.func_149663_c("extrabiomes.cattail").func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCatTail.class, "plants4");
        proxy.registerOre("reedTypha", (Block)block);
        Element.CATTAIL.set(new ItemStack((Block)block));
        proxy.registerWorldGenerator(new CatTailGenerator((Block)block));
    }

    private static void createCrackedSand() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.CRACKEDSAND.getEnabled()) {
            return;
        }
        GenericTerrainBlock block = new GenericTerrainBlock(0, Material.field_151576_e);
        block.func_149663_c("extrabiomes.crackedsand").func_149711_c(1.2f).func_149672_a(Block.field_149769_e).func_149647_a(Extrabiomes.tabsEBXL);
        block.texturePath = "crackedsand";
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, "terrain_blocks2");
        proxy.registerOre("sandCracked", (Block)block);
        ItemStack stack = new ItemStack((Block)block);
        Element.CRACKEDSAND.set(stack);
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.WASTELAND, block, block);
        ForestryModHelper.addToDiggerBackpack(stack);
    }

    private static void createFlowers() {
        if (!ModuleControlSettings.SUMMA.isEnabled()) {
            return;
        }
        boolean[] enableds = new boolean[]{BlockSettings.FLOWER.getEnabled(), BlockSettings.FLOWER2.getEnabled(), BlockSettings.FLOWER3.getEnabled()};
        CommonProxy proxy = Extrabiomes.proxy;
        FlowerGenerator generator = FlowerGenerator.getInstance();
        for (int group = 0; group < enableds.length; ++group) {
            if (!enableds[group]) continue;
            BlockCustomFlower block = new BlockCustomFlower(group, Material.field_151585_k);
            block.func_149663_c("extrabiomes.flower").func_149675_a(true).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
            proxy.registerBlock(block, ItemFlower.class, "flower" + (group + 1));
            Collection<BlockCustomFlower.BlockType> types = block.getGroupTypes();
            for (BlockCustomFlower.BlockType type : types) {
                Element element;
                try {
                    element = Element.valueOf(type.name());
                }
                catch (Exception e) {
                    LogHelper.warning("No element found for flower " + (Object)((Object)type), new Object[0]);
                    continue;
                }
                type.setBlock(block);
                ItemStack item = new ItemStack((Block)block, 1, type.metadata());
                element.set(item);
                ForestryModHelper.registerBasicFlower(item);
            }
            generator.registerBlock(block, types);
            ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        }
        proxy.registerWorldGenerator(generator);
    }

    private static void createVines() {
        BlockCustomVine.BlockType[] vines;
        if (!ModuleControlSettings.SUMMA.isEnabled()) {
            return;
        }
        CommonProxy proxy = Extrabiomes.proxy;
        for (BlockCustomVine.BlockType blockType : vines = new BlockCustomVine.BlockType[]{BlockCustomVine.BlockType.GLORIOSA}) {
            VineGenerator generator;
            Element element;
            BlockSettings settings;
            try {
                settings = BlockSettings.valueOf(blockType.name());
            }
            catch (Exception e) {
                LogHelper.severe("Unable to find settings for " + (Object)((Object)blockType), new Object[0]);
                continue;
            }
            if (!settings.getEnabled()) continue;
            BlockCustomVine block = new BlockCustomVine(blockType);
            block.func_149663_c("extrabiomes.vine." + blockType.name().toLowerCase()).func_149647_a(Extrabiomes.tabsEBXL);
            proxy.registerBlock((Block)block, ItemBlock.class, "vines");
            try {
                element = Element.valueOf("VINE_" + blockType.name());
            }
            catch (Exception e) {
                LogHelper.warning("No element found for vine " + (Object)((Object)blockType), new Object[0]);
                continue;
            }
            ItemStack item = new ItemStack((Block)block, 1);
            element.set(item);
            ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
            if (blockType == BlockCustomVine.BlockType.GLORIOSA) {
                BiomeSettings[] biomeList = new BiomeSettings[]{BiomeSettings.EXTREMEJUNGLE, BiomeSettings.MINIJUNGLE, BiomeSettings.RAINFOREST};
                generator = new VineGenerator(block, biomeList);
            } else {
                generator = new VineGenerator(block);
            }
            proxy.registerWorldGenerator(generator);
        }
    }

    private static void createGrass() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.GRASS.getEnabled()) {
            return;
        }
        BlockCustomTallGrass block = new BlockCustomTallGrass(48, Material.field_151582_l);
        block.func_149663_c("extrabiomes.tallgrass").func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemGrass.class, "grass");
        Blocks.field_150480_ab.setFireInfo((Block)block, 60, 100);
        Element.GRASS_BROWN.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.BROWN.metadata()));
        Element.GRASS_DEAD.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD.metadata()));
        Element.GRASS_BROWN_SHORT.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.SHORT_BROWN.metadata()));
        Element.GRASS_DEAD_TALL.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD_TALL.metadata()));
        Element.GRASS_DEAD_YELLOW.set(new ItemStack((Block)block, 1, BlockCustomTallGrass.BlockType.DEAD_YELLOW.metadata()));
        ItemStack grassStack = Element.GRASS_BROWN.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (WorldGenerator)new WorldGenTallGrass(Block.func_149634_a((Item)grassStack.func_77973_b()), grassStack.func_77960_j()), 100);
        grassStack = Element.GRASS_BROWN_SHORT.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (WorldGenerator)new WorldGenTallGrass(Block.func_149634_a((Item)grassStack.func_77973_b()), grassStack.func_77960_j()), 100);
        grassStack = Element.GRASS_DEAD.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(Block.func_149634_a((Item)grassStack.func_77973_b()), grassStack.func_77960_j()), 90);
        grassStack = Element.GRASS_DEAD_YELLOW.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(Block.func_149634_a((Item)grassStack.func_77973_b()), grassStack.func_77960_j()), 90);
        grassStack = Element.GRASS_DEAD_TALL.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (WorldGenerator)new WorldGenTallGrass(Block.func_149634_a((Item)grassStack.func_77973_b()), grassStack.func_77960_j()), 35);
    }

    private static void createNewLeaves() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.NEWLEAVES.getEnabled()) {
            return;
        }
        BlockNewLeaves block = new BlockNewLeaves(Material.field_151584_j, false);
        block.func_149663_c("extrabiomes.leaves").func_149675_a(true).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomNewLeaves.class, "leaves_2");
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 30, 60);
        Element.LEAVES_BALD_CYPRESS.set(new ItemStack((Block)block, 1, BlockNewLeaves.BlockType.BALD_CYPRESS.metadata()));
        Element.LEAVES_JAPANESE_MAPLE.set(new ItemStack((Block)block, 1, BlockNewLeaves.BlockType.JAPANESE_MAPLE.metadata()));
        Element.LEAVES_JAPANESE_MAPLE_SHRUB.set(new ItemStack((Block)block, 1, BlockNewLeaves.BlockType.JAPANESE_MAPLE_SHRUB.metadata()));
        Element.LEAVES_RAINBOW_EUCALYPTUS.set(new ItemStack((Block)block, 1, BlockNewLeaves.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createMoreLeaves() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.MORELEAVES.getEnabled()) {
            return;
        }
        BlockMoreLeaves block = new BlockMoreLeaves(Material.field_151584_j, false);
        block.func_149663_c("extrabiomes.leaves").func_149675_a(true).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomMoreLeaves.class, "leaves_3");
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 30, 60);
        Element.LEAVES_SAKURA_BLOSSOM.set(new ItemStack((Block)block, 1, BlockMoreLeaves.BlockType.SAKURA_BLOSSOM.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createGreenLeaves() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.GREENLEAVES.getEnabled()) {
            return;
        }
        BlockGreenLeaves block = new BlockGreenLeaves(Material.field_151584_j, false);
        block.func_149663_c("extrabiomes.leaves").func_149675_a(true).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemCustomGreenLeaves.class, "leaves_4");
        proxy.registerOreInAllSubblocks("treeLeaves", (Block)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 30, 60);
        Element.LEAVES_ACACIA.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.ACACIA.metadata()));
        Element.LEAVES_FIR.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.FIR.metadata()));
        Element.LEAVES_REDWOOD.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.REDWOOD.metadata()));
        Element.LEAVES_CYPRESS.set(new ItemStack((Block)block, 1, BlockGreenLeaves.BlockType.CYPRESS.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createLeafPile() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.LEAFPILE.getEnabled()) {
            return;
        }
        BlockLeafPile block = new BlockLeafPile(64, Material.field_151582_l);
        block.func_149663_c("extrabiomes.leafpile").func_149711_c(0.0f).func_149675_a(true).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block, "leaf_pile");
        Blocks.field_150480_ab.setFireInfo((Block)block, 30, 60);
        Element.LEAFPILE.set(new ItemStack((Block)block));
        proxy.registerWorldGenerator(new LeafPileGenerator(block));
    }

    private static void createLogs() {
        BlockHandler.createWood();
        BlockHandler.createMiniLogs();
        BlockHandler.createQuarterLogs();
        BlockHandler.createNewQuarterLogs();
        BlockHandler.createKneeLogs();
    }

    private static void createMiniLogs() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.MINILOG.getEnabled()) {
            return;
        }
        BlockMiniLog block = new BlockMiniLog(BlockSettings.MINILOG);
        extrabiomes.lib.Blocks.BLOCK_LOG_SAKURA_GROVE.set((Block)block);
        block.func_149663_c("extrabiomes.log").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((Block)block, "axe", 0);
        proxy.registerBlock((Block)block, ItemCustomMiniLog.class, "mini_log_1");
        proxy.registerOreInAllSubblocks("logWood", (Block)block);
        proxy.registerEventHandler((Object)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 5, 5);
        Element.LOG_SAKURA_BLOSSOM.set(new ItemStack((Block)block, 1, BlockMiniLog.BlockType.SAKURA_BLOSSOM.metadata()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        BlockMiniLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderMiniLog()));
    }

    private static void createKneeLogs() {
        BlockKneeLog block = new BlockKneeLog(BlockSettings.KNEELOG, "baldcypress");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.KNEELOG.getEnabled()) {
            return;
        }
        block.func_149663_c("extrabiomes.cypresskneelog");
        block.setDroppedItemStack(Element.LOG_BALD_CYPRESS.get());
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((Block)block, "axe", 0);
        proxy.registerBlock((Block)block, ItemKneeLog.class, "log_elbow_baldcypress");
        proxy.registerOreInAllSubblocks("logWood", (Block)block);
        proxy.registerEventHandler((Object)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 5, 5);
        BlockKneeLog block2 = new BlockKneeLog(BlockSettings.RAINBOWKNEELOG, "rainboweucalyptus");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.RAINBOWKNEELOG.getEnabled()) {
            return;
        }
        block2.func_149663_c("extrabiomes.rainbowkneelog");
        block2.setDroppedItemStack(Element.LOG_RAINBOW_EUCALYPTUS.get());
        proxy.setBlockHarvestLevel((Block)block2, "axe", 0);
        proxy.registerBlock((Block)block2, ItemKneeLog.class, "log_elbow_rainbow_eucalyptus");
        proxy.registerOreInAllSubblocks("logWood", (Block)block2);
        proxy.registerEventHandler((Object)block2);
        Blocks.field_150480_ab.setFireInfo((Block)block2, 5, 5);
        Element.LOG_KNEE_BALD_CYPRESS.set(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        Element.LOG_KNEE_RAINBOW_EUCALYPTUS.set(new ItemStack((Block)block2, 1, Short.MAX_VALUE));
        BlockKneeLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderKneeLog()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block2, 1, Short.MAX_VALUE));
        FacadeHelper.addBuildcraftFacade((Block)block);
        FacadeHelper.addBuildcraftFacade((Block)block2);
    }

    private static void createNewQuarterLogs() {
        CommonProxy proxy = Extrabiomes.proxy;
        BlockNewQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderNewQuarterLog()));
        BlockNewQuarterLog block = new BlockNewQuarterLog(BlockSettings.NEWQUARTERLOG, "baldcypress");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.NEWQUARTERLOG.getEnabled()) {
            return;
        }
        block.func_149663_c("extrabiomes.baldcypressquarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        block.setDroppedItemStack(Element.LOG_BALD_CYPRESS.get());
        proxy.setBlockHarvestLevel((Block)block, "axe", 0);
        proxy.registerBlock((Block)block, ItemNewQuarterLog.class, "cornerlog_baldcypress");
        proxy.registerOreInAllSubblocks("logWood", (Block)block);
        proxy.registerEventHandler((Object)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 5, 5);
        BlockNewQuarterLog block2 = new BlockNewQuarterLog(BlockSettings.RAINBOWQUARTERLOG, "rainboweucalyptus");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.RAINBOWQUARTERLOG.getEnabled()) {
            return;
        }
        block2.func_149663_c("extrabiomes.rainboweucalyptusquarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        block2.setDroppedItemStack(Element.LOG_RAINBOW_EUCALYPTUS.get());
        proxy.setBlockHarvestLevel((Block)block2, "axe", 0);
        proxy.registerBlock((Block)block2, ItemNewQuarterLog.class, "cornerlog_rainboweucalyptus");
        proxy.registerOreInAllSubblocks("logWood", (Block)block2);
        proxy.registerEventHandler((Object)block2);
        Blocks.field_150480_ab.setFireInfo((Block)block2, 5, 5);
        BlockNewQuarterLog block3 = new BlockNewQuarterLog(BlockSettings.OAKQUARTERLOG, "oak");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.OAKQUARTERLOG.getEnabled()) {
            return;
        }
        block3.func_149663_c("extrabiomes.oakquarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        block3.setDroppedItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 0));
        proxy.setBlockHarvestLevel((Block)block3, "axe", 0);
        proxy.registerBlock((Block)block3, ItemNewQuarterLog.class, "cornerlog_oak");
        proxy.registerOreInAllSubblocks("logWood", (Block)block3);
        proxy.registerEventHandler((Object)block3);
        Blocks.field_150480_ab.setFireInfo((Block)block3, 5, 5);
        BlockNewQuarterLog block4 = new BlockNewQuarterLog(BlockSettings.FIRQUARTERLOG, "fir");
        if (!ModuleControlSettings.SUMMA.isEnabled() && !BlockSettings.FIRQUARTERLOG.getEnabled()) {
            return;
        }
        block4.func_149663_c("extrabiomes.firquarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        block4.setDroppedItemStack(Element.LOG_FIR.get());
        proxy.setBlockHarvestLevel((Block)block4, "axe", 0);
        proxy.registerBlock((Block)block4, ItemNewQuarterLog.class, "cornerlog_fir");
        proxy.registerOreInAllSubblocks("logWood", (Block)block4);
        proxy.registerEventHandler((Object)block4);
        Blocks.field_150480_ab.setFireInfo((Block)block4, 5, 5);
        BlockNewQuarterLog block5 = new BlockNewQuarterLog(BlockSettings.REDWOODQUARTERLOG, "redwood");
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.REDWOODQUARTERLOG.getEnabled()) {
            return;
        }
        block5.func_149663_c("extrabiomes.redwoodquarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        block5.setDroppedItemStack(Element.LOG_REDWOOD.get());
        proxy.setBlockHarvestLevel((Block)block5, "axe", 0);
        proxy.registerBlock((Block)block5, ItemNewQuarterLog.class, "cornerlog_redwood");
        proxy.registerOreInAllSubblocks("logWood", (Block)block5);
        proxy.registerEventHandler((Object)block5);
        Blocks.field_150480_ab.setFireInfo((Block)block5, 5, 5);
        Element.LOG_QUARTER_BALD_CYPRESS.set(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        Element.LOG_QUARTER_RAINBOW_EUCALYPTUS.set(new ItemStack((Block)block2, 1, Short.MAX_VALUE));
        Element.LOG_QUARTER_OAK.set(new ItemStack((Block)block3, 1, Short.MAX_VALUE));
        Element.LOG_QUARTER_FIR.set(new ItemStack((Block)block4, 1, Short.MAX_VALUE));
        Element.LOG_QUARTER_REDWOOD.set(new ItemStack((Block)block5, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block2, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block3, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block4, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block5, 1, Short.MAX_VALUE));
    }

    private static void createQuarterLogs() {
        boolean blockIDNW = BlockSettings.QUARTERLOG0.getEnabled();
        boolean blockIDNE = BlockSettings.QUARTERLOG1.getEnabled();
        boolean blockIDSW = BlockSettings.QUARTERLOG2.getEnabled();
        boolean blockIDSE = BlockSettings.QUARTERLOG3.getEnabled();
        if (!(ModuleControlSettings.SUMMA.isEnabled() && blockIDNE && blockIDNW && blockIDSE && blockIDSW)) {
            return;
        }
        BlockQuarterLog blockNW = new BlockQuarterLog(BlockSettings.QUARTERLOG0, 144, BlockQuarterLog.BarkOn.NW);
        BlockQuarterLog blockNE = new BlockQuarterLog(BlockSettings.QUARTERLOG1, 144, BlockQuarterLog.BarkOn.NE);
        BlockQuarterLog blockSW = new BlockQuarterLog(BlockSettings.QUARTERLOG2, 144, BlockQuarterLog.BarkOn.SW);
        BlockQuarterLog blockSE = new BlockQuarterLog(BlockSettings.QUARTERLOG3, 144, BlockQuarterLog.BarkOn.SE);
        for (BlockQuarterLog blockQuarterLog : new BlockQuarterLog[]{blockNW, blockNE, blockSW, blockSE}) {
            blockQuarterLog.func_149663_c("extrabiomes.log.quarter").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f);
            CommonProxy proxy = Extrabiomes.proxy;
            proxy.setBlockHarvestLevel((Block)blockQuarterLog, "axe", 0);
            proxy.registerBlock((Block)blockQuarterLog, ItemOldQuarterLog.class, "log_old_quarter");
            proxy.registerOreInAllSubblocks("logWood", (Block)blockQuarterLog);
            proxy.registerEventHandler((Object)blockQuarterLog);
            Blocks.field_150480_ab.setFireInfo((Block)blockQuarterLog, 5, 5);
        }
        Element.LOG_HUGE_FIR_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_OAK_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_REDWOOD_NW.set(new ItemStack((Block)blockNW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_NE.set(new ItemStack((Block)blockNE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SW.set(new ItemStack((Block)blockSW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SE.set(new ItemStack((Block)blockSE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        BlockQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderQuarterLog()));
        for (BlockQuarterLog.BlockType blockType : BlockQuarterLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade((Block)blockSE, blockType.metadata());
        }
    }

    private static void createRedRock() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.REDROCK.getEnabled()) {
            return;
        }
        BlockRedRock block = new BlockRedRock();
        block.func_149663_c("extrabiomes.redrock").func_149711_c(1.5f).func_149752_b(2.0f).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, ItemRedRock.class, "terrain_blocks1");
        Element.RED_ROCK.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_ROCK.metadata()));
        Element.RED_COBBLE.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_COBBLE.metadata()));
        Element.RED_ROCK_BRICK.set(new ItemStack((Block)block, 1, BlockRedRock.BlockType.RED_ROCK_BRICK.metadata()));
        Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockActiveEvent(block));
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.MOUNTAINRIDGE, block, block);
        ForestryModHelper.addToDiggerBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        for (BlockRedRock.BlockType blockType : BlockRedRock.BlockType.values()) {
        }
    }

    private static void createSapling() {
        Element[] forestrySaplings;
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.SAPLING.getEnabled()) {
            return;
        }
        BlockCustomSapling block = new BlockCustomSapling(16);
        block.func_149663_c("extrabiomes.sapling").func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemSapling.class, "saplings_1");
        proxy.registerOreInAllSubblocks("treeSapling", (Block)block);
        Element.SAPLING_ACACIA.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.ACACIA.metadata()));
        Element.SAPLING_AUTUMN_BROWN.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.UMBER.metadata()));
        Element.SAPLING_AUTUMN_ORANGE.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.GOLDENROD.metadata()));
        Element.SAPLING_AUTUMN_PURPLE.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.VERMILLION.metadata()));
        Element.SAPLING_AUTUMN_YELLOW.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.CITRINE.metadata()));
        Element.SAPLING_FIR.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.FIR.metadata()));
        Element.SAPLING_REDWOOD.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.REDWOOD.metadata()));
        Element.SAPLING_CYPRESS.set(new ItemStack((Block)block, 1, BlockCustomSapling.BlockType.CYPRESS.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerSapling(Element.SAPLING_ACACIA.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_BROWN.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_ORANGE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_PURPLE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_YELLOW.get());
        ForestryModHelper.registerSapling(Element.SAPLING_FIR.get());
        ForestryModHelper.registerSapling(Element.SAPLING_REDWOOD.get());
        ForestryModHelper.registerSapling(Element.SAPLING_CYPRESS.get());
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_ACACIA, Element.SAPLING_AUTUMN_BROWN, Element.SAPLING_AUTUMN_ORANGE, Element.SAPLING_AUTUMN_PURPLE, Element.SAPLING_AUTUMN_YELLOW, Element.SAPLING_FIR, Element.SAPLING_CYPRESS}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler((Block)block));
    }

    private static void createNewSapling() {
        Element[] forestrySaplings;
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.NEWSAPLING.getEnabled()) {
            return;
        }
        BlockNewSapling block = new BlockNewSapling();
        block.func_149663_c("extrabiomes.sapling").func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((Block)block, ItemNewSapling.class, "saplings_2");
        proxy.registerOreInAllSubblocks("treeSapling", (Block)block);
        Element.SAPLING_BALD_CYPRESS.set(new ItemStack((Block)block, 1, BlockNewSapling.BlockType.BALD_CYPRESS.metadata()));
        Element.SAPLING_JAPANESE_MAPLE.set(new ItemStack((Block)block, 1, BlockNewSapling.BlockType.JAPANESE_MAPLE.metadata()));
        Element.SAPLING_JAPANESE_MAPLE_SHRUB.set(new ItemStack((Block)block, 1, BlockNewSapling.BlockType.JAPANESE_MAPLE_SHRUB.metadata()));
        Element.SAPLING_RAINBOW_EUCALYPTUS.set(new ItemStack((Block)block, 1, BlockNewSapling.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        Element.SAPLING_SAKURA_BLOSSOM.set(new ItemStack((Block)block, 1, BlockNewSapling.BlockType.SAKURA_BLOSSOM.metadata()));
        ItemStack stack = new ItemStack((Block)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerSapling(Element.SAPLING_BALD_CYPRESS.get());
        ForestryModHelper.registerSapling(Element.SAPLING_JAPANESE_MAPLE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_JAPANESE_MAPLE_SHRUB.get());
        ForestryModHelper.registerSapling(Element.SAPLING_RAINBOW_EUCALYPTUS.get());
        ForestryModHelper.registerSapling(Element.SAPLING_SAKURA_BLOSSOM.get());
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_JAPANESE_MAPLE, Element.SAPLING_JAPANESE_MAPLE_SHRUB, Element.SAPLING_SAKURA_BLOSSOM}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealNewEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler((Block)block));
    }

    private static void createWood() {
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.CUSTOMLOG.getEnabled()) {
            return;
        }
        BlockCustomLog block = new BlockCustomLog();
        block.func_149663_c("extrabiomes.log").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((Block)block, "axe", 0);
        proxy.registerBlock((Block)block, MultiItemBlock.class, "log1");
        proxy.registerOreInAllSubblocks("logWood", (Block)block);
        proxy.registerEventHandler((Object)block);
        Blocks.field_150480_ab.setFireInfo((Block)block, 5, 5);
        Element.LOG_ACACIA.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.ACACIA.metadata()));
        Element.LOG_FIR.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.FIR.metadata()));
        Element.LOG_CYPRESS.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.CYPRESS.metadata()));
        Element.LOG_JAPANESE_MAPLE.set(new ItemStack((Block)block, 1, BlockCustomLog.BlockType.JAPANESE_MAPLE.metadata()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block, 1, Short.MAX_VALUE));
        for (BlockCustomLog.BlockType blockType : BlockCustomLog.BlockType.values()) {
        }
        if (!ModuleControlSettings.SUMMA.isEnabled() || !BlockSettings.NEWLOG.getEnabled()) {
            return;
        }
        BlockNewLog block2 = new BlockNewLog(BlockSettings.NEWLOG);
        block2.func_149663_c("extrabiomes.newlog").func_149672_a(Block.field_149766_f).func_149711_c(2.0f).func_149752_b(Blocks.field_150364_r.func_149638_a(null) * 5.0f).func_149647_a(Extrabiomes.tabsEBXL);
        proxy.setBlockHarvestLevel((Block)block2, "axe", 0);
        proxy.registerBlock((Block)block2, MultiItemBlock.class, "log2");
        proxy.registerOreInAllSubblocks("logWood", (Block)block2);
        proxy.registerEventHandler((Object)block2);
        Blocks.field_150480_ab.setFireInfo((Block)block2, 5, 5);
        Element.LOG_RAINBOW_EUCALYPTUS.set(new ItemStack((Block)block2, 1, BlockNewLog.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        Element.LOG_AUTUMN.set(new ItemStack((Block)block2, 1, BlockNewLog.BlockType.AUTUMN.metadata()));
        Element.LOG_BALD_CYPRESS.set(new ItemStack((Block)block2, 1, BlockNewLog.BlockType.BALD_CYPRESS.metadata()));
        Element.LOG_REDWOOD.set(new ItemStack((Block)block2, 1, BlockNewLog.BlockType.REDWOOD.metadata()));
        ForestryModHelper.addToForesterBackpack(new ItemStack((Block)block2, 1, Short.MAX_VALUE));
        for (BlockNewLog.BlockType blockType : BlockNewLog.BlockType.values()) {
        }
    }
}

