/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.helpers.LogHelper;
import extrabiomes.items.ItemCustomFood;
import extrabiomes.items.ItemCustomSeed;
import extrabiomes.lib.Element;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class RecipeHandler {
    public static void init() {
        RecipeHandler.writeLogTurnerRecipe();
        RecipeHandler.writeCrackedSandRecipes();
        RecipeHandler.writeLogRecipes();
        RecipeHandler.writeLogConversionRecipes();
        RecipeHandler.writeFlowerRecipes();
        RecipeHandler.writeLeafPileRecipes();
        RecipeHandler.writeSeedRecipes();
        RecipeHandler.writeFoodRecipes();
        RecipeHandler.writeWaterPantRecipes();
    }

    private static void writeWaterPantRecipes() {
        if (!Element.WATERPLANT.isPresent()) {
            return;
        }
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 1, 2), new Object[]{Element.WATERPLANT.get()});
        Extrabiomes.proxy.addRecipe((IRecipe)recipe);
    }

    private static void writeSeedRecipes() {
        if (!Stuff.seed.isPresent() || !Stuff.crop.isPresent()) {
            return;
        }
        for (ItemCustomSeed.SeedType type : ItemCustomSeed.SeedType.values()) {
            Element crop_element;
            Element seed_element;
            try {
                seed_element = Element.valueOf("SEED_" + type.name());
                crop_element = Element.valueOf("CROP_" + type.name());
            }
            catch (Exception e) {
                LogHelper.severe("Unable to find crop source for seed " + (Object)((Object)type), new Object[0]);
                continue;
            }
            if (!seed_element.isPresent() || !crop_element.isPresent()) continue;
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(seed_element.get(), new Object[]{crop_element.get()});
            Extrabiomes.proxy.addRecipe((IRecipe)recipe);
        }
    }

    private static void writeCrackedSandRecipes() {
        if (!Element.CRACKEDSAND.isPresent()) {
            return;
        }
        ShapelessOreRecipe recipe = new ShapelessOreRecipe((Block)Blocks.field_150354_m, new Object[]{Element.CRACKEDSAND.get(), Items.field_151131_as});
        Extrabiomes.proxy.addRecipe((IRecipe)recipe);
    }

    private static void writeFlowerRecipes() {
        CommonProxy proxy = Extrabiomes.proxy;
        block9: for (Element element : Element.values()) {
            ItemStack dye;
            BlockCustomFlower.BlockType block;
            if (!element.isPresent()) continue;
            try {
                block = BlockCustomFlower.BlockType.valueOf(element.name());
            }
            catch (Exception e) {
                continue;
            }
            if (block == null) continue;
            int color = block.color();
            switch (color) {
                case -1: {
                    continue block9;
                }
                case 0: {
                    dye = Element.DYE_BLACK.get();
                    break;
                }
                case 3: {
                    dye = Element.DYE_BROWN.get();
                    break;
                }
                case 4: {
                    dye = Element.DYE_BLUE.get();
                    break;
                }
                case 15: {
                    dye = Element.DYE_WHITE.get();
                    break;
                }
                default: {
                    dye = new ItemStack(Items.field_151100_aR, 1, color);
                }
            }
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(dye, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
        }
        if (Element.VINE_GLORIOSA.isPresent()) {
            ItemStack gloriosa = Element.VINE_GLORIOSA.get();
            ItemStack dye = new ItemStack(Items.field_151100_aR, 1, 1);
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(dye, new Object[]{gloriosa});
            proxy.addRecipe((IRecipe)recipe);
        }
        if (Element.TOADSTOOL.isPresent()) {
            ItemStack toadstool = Element.TOADSTOOL.get();
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(Items.field_151009_A, new Object[]{Blocks.field_150338_P, toadstool, toadstool, Items.field_151054_z});
            proxy.addRecipe((IRecipe)recipe);
            recipe = new ShapelessOreRecipe(Items.field_151009_A, new Object[]{Blocks.field_150337_Q, toadstool, toadstool, Items.field_151054_z});
            proxy.addRecipe((IRecipe)recipe);
            recipe = new ShapelessOreRecipe(Element.DYE_BROWN.get(), new Object[]{toadstool});
            proxy.addRecipe((IRecipe)recipe);
        }
    }

    private static void writeLeafPileRecipes() {
        if (!Element.LEAFPILE.isPresent()) {
            return;
        }
        ShapedOreRecipe recipe = new ShapedOreRecipe((Block)Blocks.field_150362_t, new Object[]{new String[]{"lll", "lll", "lll"}, Character.valueOf('l'), Element.LEAFPILE.get()});
        Extrabiomes.proxy.addRecipe((IRecipe)recipe);
    }

    private static void writeLogConversionRecipes() {
        CommonProxy proxy = Extrabiomes.proxy;
        if (Element.LOG_QUARTER_BALD_CYPRESS.isPresent() && Element.LOG_BALD_CYPRESS.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_BALD_CYPRESS.get().func_77973_b(), 4, Element.LOG_BALD_CYPRESS.get().func_77960_j()), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_QUARTER_BALD_CYPRESS.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_QUARTER_BALD_CYPRESS.get().func_77973_b(), 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_BALD_CYPRESS.get()}));
        }
        if (Element.LOG_KNEE_BALD_CYPRESS.isPresent() && Element.LOG_BALD_CYPRESS.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_BALD_CYPRESS.get().func_77973_b(), 3, Element.LOG_BALD_CYPRESS.get().func_77960_j()), new Object[]{new String[]{" l", "ll"}, Character.valueOf('l'), Element.LOG_KNEE_BALD_CYPRESS.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_KNEE_BALD_CYPRESS.get().func_77973_b(), 3, 0), new Object[]{new String[]{" l", "ll"}, Character.valueOf('l'), Element.LOG_BALD_CYPRESS.get()}));
        }
        if (Element.LOG_QUARTER_RAINBOW_EUCALYPTUS.isPresent() && Element.LOG_RAINBOW_EUCALYPTUS.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_RAINBOW_EUCALYPTUS.get().func_77973_b(), 4, Element.LOG_RAINBOW_EUCALYPTUS.get().func_77960_j()), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_QUARTER_RAINBOW_EUCALYPTUS.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_QUARTER_RAINBOW_EUCALYPTUS.get().func_77973_b(), 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_RAINBOW_EUCALYPTUS.get()}));
        }
        if (Element.LOG_KNEE_RAINBOW_EUCALYPTUS.isPresent() && Element.LOG_RAINBOW_EUCALYPTUS.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_RAINBOW_EUCALYPTUS.get().func_77973_b(), 3, Element.LOG_RAINBOW_EUCALYPTUS.get().func_77960_j()), new Object[]{new String[]{" l", "ll"}, Character.valueOf('l'), Element.LOG_KNEE_RAINBOW_EUCALYPTUS.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_KNEE_RAINBOW_EUCALYPTUS.get().func_77973_b(), 3, 0), new Object[]{new String[]{" l", "ll"}, Character.valueOf('l'), Element.LOG_RAINBOW_EUCALYPTUS.get()}));
        }
        if (Element.LOG_QUARTER_FIR.isPresent() && Element.LOG_FIR.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_FIR.get().func_77973_b(), 4, Element.LOG_FIR.get().func_77960_j()), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_QUARTER_FIR.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_QUARTER_FIR.get().func_77973_b(), 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_FIR.get()}));
        }
        if (Element.LOG_QUARTER_FIR.isPresent() && Element.LOG_HUGE_FIR_SE.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Element.LOG_QUARTER_FIR.get().func_77973_b(), 1, 0), new Object[]{Element.LOG_HUGE_FIR_SE.get()}));
        }
        if (Element.LOG_REDWOOD.isPresent() && Element.LOG_REDWOOD.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_REDWOOD.get().func_77973_b(), 4, Element.LOG_REDWOOD.get().func_77960_j()), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_QUARTER_REDWOOD.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_QUARTER_REDWOOD.get().func_77973_b(), 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_REDWOOD.get()}));
        }
        if (Element.LOG_QUARTER_REDWOOD.isPresent() && Element.LOG_HUGE_REDWOOD_SE.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Element.LOG_QUARTER_REDWOOD.get().func_77973_b(), 1, 0), new Object[]{Element.LOG_HUGE_REDWOOD_SE.get()}));
        }
        if (Element.LOG_HUGE_OAK_SE.isPresent() && Element.LOG_QUARTER_OAK.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Element.LOG_QUARTER_OAK.get().func_77973_b(), 1, 0), new Object[]{Element.LOG_HUGE_OAK_SE.get()}));
        }
        if (Element.LOG_QUARTER_OAK.isPresent()) {
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150364_r, 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), Element.LOG_QUARTER_OAK.get()}));
            proxy.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Element.LOG_QUARTER_OAK.get().func_77973_b(), 4, 0), new Object[]{new String[]{"ll", "ll"}, Character.valueOf('l'), new ItemStack(Blocks.field_150364_r, 1, 0)}));
        }
    }

    private static void writeLogRecipes() {
        ShapelessOreRecipe recipe;
        ItemStack cypressPlanks;
        ShapelessOreRecipe recipe2;
        ShapelessOreRecipe recipe3;
        if (!Stuff.planks.isPresent()) {
            return;
        }
        CommonProxy proxy = Extrabiomes.proxy;
        Block block = (Block)Stuff.planks.get();
        ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
        if (Element.LOG_ACACIA.isPresent()) {
            ItemStack logAcacia = Element.LOG_ACACIA.get();
            ItemStack acaciaPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.ACACIA.metadata());
            ShapelessOreRecipe recipe32 = new ShapelessOreRecipe(acaciaPlanks, new Object[]{logAcacia});
            proxy.addRecipe((IRecipe)recipe32);
            proxy.addSmelting(logAcacia, charcoal, 0.15f);
        }
        if (Element.LOG_JAPANESE_MAPLE.isPresent()) {
            ItemStack logMaple = Element.LOG_JAPANESE_MAPLE.get();
            ItemStack maplePlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.JAPANESE_MAPLE.metadata());
            recipe3 = new ShapelessOreRecipe(maplePlanks, new Object[]{logMaple});
            proxy.addRecipe((IRecipe)recipe3);
            proxy.addSmelting(logMaple, charcoal, 0.15f);
        }
        if (Element.LOG_AUTUMN.isPresent()) {
            ItemStack logAutumn = Element.LOG_AUTUMN.get();
            ItemStack autumnPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.AUTUMN.metadata());
            recipe3 = new ShapelessOreRecipe(autumnPlanks, new Object[]{logAutumn});
            proxy.addRecipe((IRecipe)recipe3);
            proxy.addSmelting(logAutumn, charcoal, 0.15f);
        }
        if (Element.LOG_HUGE_OAK_NW.isPresent() && Element.LOG_HUGE_OAK_NE.isPresent() && Element.LOG_HUGE_OAK_SW.isPresent() && Element.LOG_HUGE_OAK_SE.isPresent()) {
            for (Element element : new ItemStack[]{Element.LOG_HUGE_OAK_NW.get(), Element.LOG_HUGE_OAK_NE.get(), Element.LOG_HUGE_OAK_SW.get(), Element.LOG_HUGE_OAK_SE.get()}) {
                ShapelessOreRecipe recipe22 = new ShapelessOreRecipe(new ItemStack(Blocks.field_150364_r), new Object[]{element});
                Extrabiomes.proxy.addRecipe((IRecipe)recipe22);
            }
        }
        if (Element.LOG_FIR.isPresent() && Element.LOG_HUGE_FIR_NW.isPresent() && Element.LOG_HUGE_FIR_NE.isPresent() && Element.LOG_HUGE_FIR_SW.isPresent() && Element.LOG_HUGE_FIR_SE.isPresent()) {
            for (Element element : new ItemStack[]{Element.LOG_HUGE_FIR_NW.get(), Element.LOG_HUGE_FIR_NE.get(), Element.LOG_HUGE_FIR_SW.get(), Element.LOG_HUGE_FIR_SE.get()}) {
                recipe2 = new ShapelessOreRecipe(Element.LOG_FIR.get(), new Object[]{element});
                Extrabiomes.proxy.addRecipe((IRecipe)recipe2);
            }
        }
        if (Element.LOG_REDWOOD.isPresent() && Element.LOG_HUGE_REDWOOD_NW.isPresent() && Element.LOG_HUGE_REDWOOD_NE.isPresent() && Element.LOG_HUGE_REDWOOD_SW.isPresent() && Element.LOG_HUGE_REDWOOD_SE.isPresent()) {
            for (Element element : new ItemStack[]{Element.LOG_HUGE_REDWOOD_NW.get(), Element.LOG_HUGE_REDWOOD_NE.get(), Element.LOG_HUGE_REDWOOD_SW.get(), Element.LOG_HUGE_REDWOOD_SE.get()}) {
                recipe2 = new ShapelessOreRecipe(Element.LOG_REDWOOD.get(), new Object[]{element});
                Extrabiomes.proxy.addRecipe((IRecipe)recipe2);
            }
        }
        for (Element element : new Element[]{Element.LOG_CYPRESS}) {
            if (!element.isPresent()) continue;
            cypressPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.CYPRESS.metadata());
            recipe = new ShapelessOreRecipe(cypressPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_SAKURA_BLOSSOM}) {
            if (!element.isPresent()) continue;
            ItemStack sakuraPlanks = new ItemStack(block, 2, BlockCustomWood.BlockType.SAKURA_BLOSSOM.metadata());
            recipe = new ShapelessOreRecipe(sakuraPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_BALD_CYPRESS, Element.LOG_QUARTER_BALD_CYPRESS, Element.LOG_KNEE_BALD_CYPRESS}) {
            if (!element.isPresent()) continue;
            cypressPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.BALD_CYPRESS.metadata());
            recipe = new ShapelessOreRecipe(cypressPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_RAINBOW_EUCALYPTUS, Element.LOG_QUARTER_RAINBOW_EUCALYPTUS, Element.LOG_KNEE_RAINBOW_EUCALYPTUS}) {
            if (!element.isPresent()) continue;
            ItemStack rainbowPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.RAINBOW_EUCALYPTUS.metadata());
            recipe = new ShapelessOreRecipe(rainbowPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_FIR, Element.LOG_QUARTER_FIR}) {
            if (!element.isPresent()) continue;
            ItemStack firPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.FIR.metadata());
            recipe = new ShapelessOreRecipe(firPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_QUARTER_REDWOOD, Element.LOG_REDWOOD}) {
            if (!element.isPresent()) continue;
            ItemStack redwoodPlanks = new ItemStack(block, 4, BlockCustomWood.BlockType.REDWOOD.metadata());
            recipe = new ShapelessOreRecipe(redwoodPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
        for (Element element : new Element[]{Element.LOG_QUARTER_OAK}) {
            if (!element.isPresent()) continue;
            ItemStack oakPlanks = new ItemStack(Blocks.field_150344_f, 4);
            recipe = new ShapelessOreRecipe(oakPlanks, new Object[]{element.get()});
            proxy.addRecipe((IRecipe)recipe);
            proxy.addSmelting(element.get(), charcoal, 0.15f);
        }
    }

    private static void writeLogTurnerRecipe() {
        if (!Element.LOGTURNER.isPresent()) {
            return;
        }
        ShapedOreRecipe recipe = new ShapedOreRecipe(Element.LOGTURNER.get(), new Object[]{new String[]{"ss", " s", "ss"}, Character.valueOf('s'), "stickWood"});
        Extrabiomes.proxy.addRecipe((IRecipe)recipe);
    }

    private static void writeFoodRecipes() {
        if (!Stuff.food.isPresent()) {
            return;
        }
        Item foodItem = (Item)Stuff.food.get();
        CommonProxy proxy = Extrabiomes.proxy;
        ItemStack chocolate = new ItemStack(foodItem, 1, ItemCustomFood.FoodType.CHOCOLATE.meta);
        ItemStack cocoa_powder = new ItemStack(Items.field_151100_aR, 1, 3);
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(chocolate, new Object[]{cocoa_powder, Items.field_151102_aT, Items.field_151117_aB});
        proxy.addRecipe((IRecipe)recipe);
        ItemStack choco_strawberry = new ItemStack(foodItem, 1, ItemCustomFood.FoodType.CHOCOLATE_STRAWBERRY.meta);
        recipe = new ShapelessOreRecipe(choco_strawberry, new Object[]{chocolate, "cropStrawberry"});
        proxy.addRecipe((IRecipe)recipe);
    }
}

