/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import java.util.List;
import net.minecraft.block.BlockColored;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class ItemCustomDye
extends Item {
    private static Element[] elements = new Element[]{Element.DYE_BLACK, Element.DYE_BLUE, Element.DYE_BROWN, Element.DYE_WHITE};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] dyeIIcons;

    public ItemCustomDye() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        if (Color.values().length != elements.length) {
            LogHelper.severe("Dye color vs elements count mismatch!", new Object[0]);
        }
    }

    public void init() {
        for (int idx = 0; idx < elements.length; ++idx) {
            Color color = Color.values()[idx];
            Element element = elements[idx];
            LogHelper.info((Object)((Object)color) + " = " + (Object)((Object)element), new Object[0]);
            element.set(new ItemStack((Item)this, 1, color.meta));
            OreDictionary.registerOre((String)("dye" + StringUtils.capitalize((String)color.name)), (ItemStack)element.get());
        }
    }

    public boolean func_111207_a(ItemStack itemStack, EntityPlayer player, EntityLivingBase target) {
        if (target instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)target;
            int damage = itemStack.func_77960_j();
            Color color = Color.values()[damage];
            int i = BlockColored.func_150031_c((int)color.mcDamage);
            LogHelper.info("Dying sheep " + damage + "/" + (Object)((Object)color) + " = " + i, new Object[0]);
            if (!sheep.func_70892_o() && sheep.func_70896_n() != i) {
                sheep.func_70891_b(i);
                --itemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        int j = MathHelper.func_76125_a((int)meta, (int)0, (int)Color.values().length);
        return this.dyeIIcons[j];
    }

    public String func_77667_c(ItemStack itemStack) {
        int i = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)Color.values().length);
        return super.func_77658_a() + "." + Color.values()[i].name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < elements.length; ++j) {
            list.add(elements[j].get());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        Color[] colors = Color.values();
        this.dyeIIcons = new IIcon[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            String IIconPath = Extrabiomes.TEXTURE_PATH + "dye_" + colors[i].name;
            this.dyeIIcons[i] = iconRegister.func_94245_a(IIconPath);
        }
    }

    public static enum Color {
        BLACK("black", 0, 0x1E1B1B, 0),
        BLUE("blue", 1, 2437522, 4),
        BROWN("brown", 2, 5320730, 3),
        WHITE("white", 3, 0xF0F0F0, 15);

        public final String name;
        public final int meta;
        public final int hex;
        public final int mcDamage;

        private Color(String name, int meta, int hex, int mcDamage) {
            this.name = name;
            this.meta = meta;
            this.hex = hex;
            this.mcDamage = mcDamage;
        }
    }
}

