/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.LogHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCustomSeed
extends Item
implements IPlantable {
    private final int NUM_SEEDS;

    public ItemCustomSeed() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("extrabiomes.seed");
        this.func_77637_a(Extrabiomes.tabsEBXL);
        this.NUM_SEEDS = SeedType.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (SeedType type : SeedType.values()) {
            String IIconPath = Extrabiomes.TEXTURE_PATH + "seed_" + type.name().toLowerCase();
            type.IIcon = iconRegister.func_94245_a(IIconPath);
        }
    }

    public int func_77647_b(int meta) {
        return MathHelper.func_76125_a((int)meta, (int)0, (int)this.NUM_SEEDS);
    }

    public IIcon func_77617_a(int meta) {
        return this.getSeedType((int)meta).IIcon;
    }

    public SeedType getSeedType(int meta) {
        return SeedType.values()[this.func_77647_b(meta)];
    }

    public String func_77667_c(ItemStack itemStack) {
        SeedType seed = this.getSeedType(itemStack.func_77960_j());
        return super.func_77658_a() + "." + seed.name().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (SeedType type : SeedType.values()) {
            list.add(new ItemStack(item, 1, type.meta));
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float px, float py, float pz) {
        Block soil;
        if (side != ForgeDirection.UP.ordinal()) {
            return false;
        }
        if (player.func_82247_a(x, y, z, side, itemStack) && player.func_82247_a(x, y + 1, z, side, itemStack) && (soil = world.func_147439_a(x, y, z)) != null && soil.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this) && world.func_147437_c(x, y + 1, z)) {
            SeedType seed = this.getSeedType(itemStack.func_77960_j());
            if (seed == null || seed.cropType == null) {
                LogHelper.severe("Got NULL seed type or crop when planting " + itemStack, new Object[0]);
            } else {
                world.func_147449_b(x, y + 1, z, (Block)seed.cropType);
                --itemStack.field_77994_a;
                return true;
            }
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public static enum SeedType {
        STRAWBERRY(0);

        public final int meta;
        public BlockFlower cropType;
        public IIcon IIcon;

        private SeedType(int meta) {
            this.meta = meta;
        }
    }
}

