/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.forestry;

import com.google.common.base.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    private static Object fermenterManager;
    private static Object carpenterManager;
    private static Object flowerRegistry;
    private static boolean enabled;
    private static ArrayList plainFlowers;
    private static ArrayList[] backpackItems;
    private static Optional<Method> carpenterAddRecipe;
    private static Optional<Method> fermenterAddRecipe;
    private static Optional<Method> registerFlower;
    private static final int DIGGER = 1;
    private static final int FORESTER = 2;
    private static int BIOMASS_SAPLINGS;

    static ItemStack getBlock(String name) {
        return GameRegistry.findItemStack((String)"Forestry", (String)name, (int)1);
    }

    private static void addBackPackItems() {
        Collection<ItemStack> items = ForestryModHelper.getForesterBackPackItems();
        for (ItemStack item : items) {
            backpackItems[2].add(item);
        }
        items = ForestryModHelper.getDiggerBackPackItems();
        for (ItemStack item : items) {
            backpackItems[1].add(item);
        }
        if (Stuff.quickSand.isPresent()) {
            backpackItems[1].add(new ItemStack((Block)Stuff.quickSand.get()));
        }
    }

    private static void addBasicFlowers() {
        if (registerFlower.isPresent()) {
            try {
                String[] flowerTypes = new String[]{"flowersVanilla"};
                for (ItemStack flower : ForestryModHelper.getBasicFlowers()) {
                    Block block = Block.func_149634_a((Item)flower.func_77973_b());
                    int meta = flower.func_77960_j();
                    ((Method)registerFlower.get()).invoke(flowerRegistry, block, meta, 1.0, flowerTypes);
                }
            }
            catch (Exception e) {
                LogHelper.severe("The forestry API changed in regards to flowers.", new Object[0]);
            }
        } else {
            for (ItemStack flower : ForestryModHelper.getBasicFlowers()) {
                plainFlowers.add(flower);
            }
        }
    }

    private static void addSaplingRecipes() {
        if (fermenterAddRecipe.isPresent()) {
            for (String type : new String[]{"water", "biomass", "honey", "juice"}) {
                if (FluidRegistry.isFluidRegistered((String)type)) continue;
                LogHelper.warning("Unable to find fluid named '%s' when adding Forestry fermenter recipes.", type);
                return;
            }
            try {
                for (ItemStack sapling : ForestryModHelper.getSaplings()) {
                    ((Method)fermenterAddRecipe.get()).invoke(fermenterManager, sapling, BIOMASS_SAPLINGS, Float.valueOf(1.0f), ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("water"));
                    ((Method)fermenterAddRecipe.get()).invoke(fermenterManager, sapling, BIOMASS_SAPLINGS, Float.valueOf(1.5f), ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("juice"));
                    ((Method)fermenterAddRecipe.get()).invoke(fermenterManager, sapling, BIOMASS_SAPLINGS, Float.valueOf(1.5f), ForestryPlugin.getFluidStack("biomass"), ForestryPlugin.getFluidStack("honey"));
                }
            }
            catch (Exception e) {
                LogHelper.severe("The forestry API changed in reguards to fluids/liquids.", new Object[0]);
            }
        }
    }

    private static void addRedrockCarpenterRecipes() {
        try {
            if (carpenterAddRecipe.isPresent() && Element.RED_COBBLE.isPresent()) {
                ((Method)carpenterAddRecipe.get()).invoke(carpenterManager, 10, ForestryPlugin.getFluidStack("water", 3000), null, new ItemStack(Items.field_151119_aD, 4), new Object[]{"#", Character.valueOf('#'), Element.RED_COBBLE.get()});
            }
        }
        catch (Exception e) {
            LogHelper.severe("The forestry API changed for the carpenter.", new Object[0]);
        }
    }

    private static void addSoils() {
        Optional soil = Optional.fromNullable((Object)ForestryPlugin.getBlock("soil"));
        if (soil.isPresent()) {
            Block soilBlock = Block.func_149634_a((Item)((ItemStack)soil.get()).func_77973_b());
            TreeSoilRegistry.addValidSoil(soilBlock);
            BlockCustomSapling.setForestrySoil(soilBlock);
            BlockNewSapling.setForestrySoil(soilBlock);
        }
    }

    private static void addSaplings() {
        for (ItemStack sapling : ForestryModHelper.getSaplings()) {
            Block blockSapling = Block.func_149634_a((Item)sapling.func_77973_b());
            String saplingName = GameData.getBlockRegistry().func_148750_c((Object)blockSapling);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.%s", saplingName, sapling.func_77960_j()));
        }
    }

    private static FluidStack getFluidStack(String name) {
        return ForestryPlugin.getFluidStack(name, 1000);
    }

    private static FluidStack getFluidStack(String name, int ammount) {
        return FluidRegistry.getFluidStack((String)name, (int)ammount);
    }

    public static void init() {
        if (!ForestryPlugin.isEnabled()) {
            return;
        }
        ForestryPlugin.setupPlugin();
        ForestryPlugin.addSoils();
        ForestryPlugin.addSaplings();
        ForestryPlugin.addBasicFlowers();
        ForestryPlugin.addBackPackItems();
        ForestryPlugin.addRedrockCarpenterRecipes();
        ForestryPlugin.addSaplingRecipes();
    }

    private static boolean isEnabled() {
        return enabled && Extrabiomes.proxy.isModLoaded("Forestry");
    }

    public static void setupPlugin() {
        if (!ForestryPlugin.isEnabled()) {
            return;
        }
        LogHelper.fine("Initializing %s plugin.", "Forestry");
        try {
            Class<?> cls = Class.forName("forestry.api.recipes.RecipeManagers");
            Field fld = cls.getField("fermenterManager");
            fermenterManager = fld.get(null);
            fld = cls.getField("carpenterManager");
            carpenterManager = fld.get(null);
            cls = Class.forName("forestry.api.apiculture.FlowerManager");
            try {
                fld = cls.getField("plainFlowers");
                plainFlowers = (ArrayList)fld.get(null);
            }
            catch (NoSuchFieldException e) {
                fld = cls.getField("flowerRegistry");
                flowerRegistry = fld.get(null);
                cls = Class.forName("forestry.api.genetics.IFlowerRegistry");
                registerFlower = Optional.fromNullable((Object)cls.getMethod("registerPlantableFlower", Block.class, Integer.TYPE, Double.TYPE, String[].class));
            }
            cls = Class.forName("forestry.api.storage.BackpackManager");
            fld = cls.getField("backpackItems");
            backpackItems = (ArrayList[])fld.get(null);
            cls = Class.forName("forestry.api.recipes.IFermenterManager");
            fermenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", ItemStack.class, Integer.TYPE, Float.TYPE, FluidStack.class, FluidStack.class));
            cls = Class.forName("forestry.api.recipes.ICarpenterManager");
            carpenterAddRecipe = Optional.fromNullable((Object)cls.getMethod("addRecipe", Integer.TYPE, FluidStack.class, ItemStack.class, ItemStack.class, Object[].class));
            cls = Class.forName("forestry.api.core.ForestryAPI");
            fld = cls.getField("activeMode");
            Object activeMode = fld.get(null);
            cls = Class.forName("forestry.api.core.IGameMode");
            Optional getIntegerSetting = Optional.fromNullable((Object)cls.getMethod("getIntegerSetting", String.class));
            BIOMASS_SAPLINGS = (Integer)((Method)getIntegerSetting.get()).invoke(activeMode, "fermenter.yield.sapling");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine("Could not communicate with %s. Disabling plugin.", "Forestry");
            enabled = false;
        }
    }

    static {
        enabled = true;
        carpenterAddRecipe = Optional.absent();
        fermenterAddRecipe = Optional.absent();
        registerFlower = Optional.absent();
    }
}

