/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.newdawn;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import extrabiomes.Extrabiomes;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.amica.newdawn.EBXLAridSelector;
import extrabiomes.module.amica.newdawn.EBXLDampSelector;
import extrabiomes.module.amica.newdawn.EBXLNormalSelector;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;
import two.newdawn.API.NewDawnBiome;
import two.newdawn.API.NewDawnBiomeProvider;
import two.newdawn.API.NewDawnBiomeSelector;
import two.newdawn.API.NewDawnRegistry;
import two.newdawn.API.noise.NoiseStretch;
import two.newdawn.API.noise.SimplexNoise;

public class NewDawnPluginImpl
implements NewDawnBiomeProvider {
    private static boolean enabled = true;

    @SubscribeEvent
    public void init() {
        if (!this.isEnabled()) {
            return;
        }
        LogHelper.info("Registering NewDawn biome provider...", new Object[0]);
        NewDawnRegistry.registerProvider((NewDawnBiomeProvider)this);
    }

    private boolean isEnabled() {
        return enabled && Extrabiomes.proxy.isModLoaded("newdawn");
    }

    public static NewDawnBiome getBiomeIfEnabled(BiomeSettings biome) {
        if (biome != null && biome.isEnabled()) {
            BiomeGenBase gen;
            try {
                gen = (BiomeGenBase)biome.getBiome().get();
            }
            catch (Exception e) {
                return null;
            }
            return NewDawnBiome.copyVanilla((BiomeGenBase)gen);
        }
        return null;
    }

    public static int fuzzValue(int value, Random rng) {
        double fuzz = 0.2 * (double)value * rng.nextDouble();
        double result = 0.9 * (double)value + fuzz;
        return (int)result;
    }

    public static NoiseStretch getFuzzyStretch(int size, SimplexNoise noise) {
        Random rng = noise.getRandom();
        int sizeX = NewDawnPluginImpl.fuzzValue(size, rng);
        int sizeZ = NewDawnPluginImpl.fuzzValue(size, rng);
        NoiseStretch stretch = noise.generateNoiseStretcher((double)sizeX, (double)sizeZ, rng.nextDouble(), rng.nextDouble());
        return stretch;
    }

    public Set<NewDawnBiomeSelector> getBiomeSelectors(SimplexNoise worldNoise) {
        HashSet<NewDawnBiomeSelector> selectors = new HashSet<NewDawnBiomeSelector>();
        selectors.add(new EBXLAridSelector(worldNoise, 450));
        selectors.add(new EBXLDampSelector(worldNoise, 500));
        selectors.add(new EBXLNormalSelector(worldNoise, 550));
        return selectors;
    }
}

