/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenAcacia
extends WorldGenAbstractTree {
    private static long lastSeed = 0L;

    public WorldGenAcacia(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int y1;
        int height = rand.nextInt(4) + 6;
        boolean canGrow = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y12 = y; y12 <= y + 1 + height; ++y12) {
            int clearance = 1;
            if (y12 == y) {
                clearance = 0;
            }
            if (y12 >= y + 1 + height - 2) {
                clearance = 2;
            }
            for (int x1 = x - clearance; x1 <= x + clearance && canGrow; ++x1) {
                for (int z1 = z - clearance; z1 <= z + clearance && canGrow; ++z1) {
                    if (y12 >= 0 && y12 < 256) {
                        Block block = world.func_147439_a(x1, y12, z1);
                        if (block == null || block.isLeaves((IBlockAccess)world, x1, y12, z1) || block.equals(Blocks.field_150349_c) || block.equals(Blocks.field_150346_d) || block.isWood((IBlockAccess)world, x1, y12, z1) || block.isReplaceable((IBlockAccess)world, x1, y12, z1)) continue;
                        canGrow = false;
                        continue;
                    }
                    canGrow = false;
                }
            }
        }
        if (!canGrow) {
            return false;
        }
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z)) || y >= 256 - height - 1) {
            return false;
        }
        world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
        int canopyHeight = 3;
        boolean minCanopyRadius = false;
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int distanceFromTop = y1 - (y + height);
            int canopyRadius = 1 - distanceFromTop;
            for (int x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                int xOnRadius = x1 - x;
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    int zOnRadius = z1 - z;
                    Block block = world.func_147439_a(x1, y1, z1);
                    if (Math.abs(xOnRadius) == canopyRadius && Math.abs(zOnRadius) == canopyRadius && (rand.nextInt(2) == 0 || distanceFromTop == 0) || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, x1, y1, z1)) continue;
                    this.func_150516_a(world, x1, y1, z1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                }
            }
        }
        for (y1 = 0; y1 < height; ++y1) {
            Block block = world.func_147439_a(x, y + y1, z);
            if (block != null && !block.isLeaves((IBlockAccess)world, x, y + y1, z) && !block.isAir((IBlockAccess)world, x, y + y1, z)) continue;
            this.func_150516_a(world, x, y + y1, z, TreeBlock.TRUNK.getBlock(), TreeBlock.TRUNK.getMetadata());
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Blocks.field_150362_t)),
        TRUNK(new ItemStack(Blocks.field_150364_r));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_ACACIA.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_ACACIA.get();
            }
            if (Element.LOG_ACACIA.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_ACACIA.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public Item getItem() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77973_b();
        }

        public Block getBlock() {
            return Block.func_149634_a((Item)this.getItem());
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

