/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenRedwood
extends WorldGenAbstractTree {
    private static long lastSeed = 0L;

    public WorldGenRedwood(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z);
    }

    public boolean generate(World world, long seed, int x, int y, int z) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z);
    }

    private boolean generateTree(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(30) + 32;
        int j = 1 + rand.nextInt(12);
        int k = height - j;
        int l = 2 + rand.nextInt(6);
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        if (!TreeSoilRegistry.isValidSoil(world.func_147439_a(x, y - 1, z)) || y >= 256 - height - 1) {
            return false;
        }
        for (int y1 = y; y1 <= y + 1 + height; ++y1) {
            int k1 = 1;
            k1 = y1 - y < j ? 0 : l;
            for (int x1 = x - k1; x1 <= x + k1; ++x1) {
                for (int z1 = z - k1; z1 <= z + k1; ++z1) {
                    if (y1 >= 0 && y1 < 256) {
                        Block block = world.func_147439_a(x1, y1, z1);
                        if (block == null || !block.isLeaves((IBlockAccess)world, x1, y1, z1)) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        world.func_147449_b(x, y - 1, z, Blocks.field_150346_d);
        world.func_147449_b(x - 1, y - 1, z, Blocks.field_150346_d);
        world.func_147449_b(x, y - 1, z - 1, Blocks.field_150346_d);
        world.func_147449_b(x - 1, y - 1, z - 1, Blocks.field_150346_d);
        int l1 = rand.nextInt(2);
        int j2 = 1;
        boolean flag1 = false;
        for (int i3 = 0; i3 <= k; ++i3) {
            int y1 = y + height - i3;
            for (int x1 = x - l1; x1 <= x + l1; ++x1) {
                int k4 = x1 - x;
                for (int z1 = z - l1; z1 <= z + l1; ++z1) {
                    int i5 = z1 - z;
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0) continue;
                    Block block = world.func_147439_a(x1, y1, z1);
                    if (block.isAir((IBlockAccess)world, x1, y1, z1) || block.canBeReplacedByLeaves((IBlockAccess)world, x1, y1, z1)) {
                        this.func_150516_a(world, x1, y1, z1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((block = world.func_147439_a(x1 - 1, y1, z1)).isAir((IBlockAccess)world, x1 - 1, y1, z1) || block.canBeReplacedByLeaves((IBlockAccess)world, x1 - 1, y1, z1)) {
                        this.func_150516_a(world, x1 - 1, y1, z1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((block = world.func_147439_a(x1, y1, z1 - 1)).isAir((IBlockAccess)world, x1, y1, z1 - 1) || block.canBeReplacedByLeaves((IBlockAccess)world, x1, y1, z1 - 1)) {
                        this.func_150516_a(world, x1, y1, z1 - 1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                    }
                    if (!(block = world.func_147439_a(x1 - 1, y1, z1 - 1)).isAir((IBlockAccess)world, x1 - 1, y1, z1 - 1) && !block.canBeReplacedByLeaves((IBlockAccess)world, x1 - 1, y1, z1 - 1)) continue;
                    this.func_150516_a(world, x1 - 1, y1, z1 - 1, TreeBlock.LEAVES.getBlock(), TreeBlock.LEAVES.getMetadata());
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
        int j3 = rand.nextInt(3);
        for (int y1 = 0; y1 < height - j3; ++y1) {
            Block j4 = world.func_147439_a(x, y + y1, z);
            if (j4 != null && !j4.isLeaves((IBlockAccess)world, x, y + y1, z)) continue;
            this.func_150516_a(world, x, y + y1, z, TreeBlock.TRUNK.getBlock(), 2);
            this.func_150516_a(world, x - 1, y + y1, z, TreeBlock.TRUNK.getBlock(), 3);
            this.func_150516_a(world, x, y + y1, z - 1, TreeBlock.TRUNK.getBlock(), 1);
            this.func_150516_a(world, x - 1, y + y1, z - 1, TreeBlock.TRUNK.getBlock(), 0);
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Blocks.field_150362_t)),
        TRUNK(new ItemStack(Blocks.field_150364_r, 1, 1));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_REDWOOD.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_REDWOOD.get();
            }
            if (Element.LOG_QUARTER_REDWOOD.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_QUARTER_REDWOOD.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public Block getBlock() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return Block.func_149634_a((Item)this.stack.func_77973_b());
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

