/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.utility;

import extrabiomes.helpers.LogHelper;
import java.io.File;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class EnhancedConfiguration
extends Configuration {
    public static final String CATEGORY_BIOME = "biome";
    public static final String CATEGORY_DECORATION = "decoration";
    public static final String CATEGORY_NEWDAWN = "newdawn";
    public static final String CATEGORY_VERSION = "version";
    public static final String CATEGORY_BLOCK = "block";
    private final boolean[] configBiomes = new boolean[BiomeGenBase.func_150565_n().length];

    public EnhancedConfiguration(File file) {
        super(file);
    }

    public Property getBiome(String key, int defaultID) {
        return this.getBiome(CATEGORY_BIOME, key, defaultID);
    }

    public Property getBiome(String category, String key, int defaultID) {
        Property prop = this.get(category, key, defaultID);
        if (prop.getInt() == -1) {
            return prop;
        }
        if (BiomeGenBase.func_150565_n()[prop.getInt()] == null && !this.configBiomes[prop.getInt()]) {
            prop.set(Integer.toString(prop.getInt()));
            this.configBiomes[prop.getInt()] = true;
            return prop;
        }
        if (this.configBiomes[prop.getInt()]) {
            LogHelper.warning("Warning two of Extrabiomes were set to Biome ID #%d in your config file.", prop.getInt());
        } else if (prop.getInt() != defaultID) {
            String msg = "Warning biome ID conflict.\n";
            msg = msg + "According to ExtrabiomesXL's config file, biome id #%d was used by %s, but it has been overwritten by %s.\n";
            msg = msg + "Any existing worlds may have incorrect biome information.";
            LogHelper.warning(msg, prop.getInt(), key, BiomeGenBase.func_150565_n()[prop.getInt()].func_150562_l().getName() + ":" + BiomeGenBase.func_150565_n()[prop.getInt()].field_76791_y);
        }
        for (int j = 40; j < this.configBiomes.length - 1; ++j) {
            if (BiomeGenBase.func_150565_n()[j] != null || this.configBiomes[j]) continue;
            prop.set(Integer.toString(j));
            this.configBiomes[j] = true;
            return prop;
        }
        throw new RuntimeException("No more biome ids available for " + key);
    }
}

