/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class ElementFluidTank
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/FluidTank.png");
    public static final int DEFAULT_SCALE = 60;
    protected IFluidTank tank;
    protected int gaugeType;
    protected boolean alwaysShowMinimum = false;

    public ElementFluidTank(GuiBase guiBase, int n, int n2, IFluidTank iFluidTank) {
        super(guiBase, n, n2);
        this.tank = iFluidTank;
        this.texture = DEFAULT_TEXTURE;
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = 60;
    }

    public ElementFluidTank(GuiBase guiBase, int n, int n2, IFluidTank iFluidTank, String string) {
        super(guiBase, n, n2);
        this.tank = iFluidTank;
        this.texture = new ResourceLocation(string);
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = 60;
    }

    public ElementFluidTank setGauge(int n) {
        this.gaugeType = n;
        return this;
    }

    public ElementFluidTank setAlwaysShow(boolean bl) {
        this.alwaysShowMinimum = bl;
        return this;
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        int n3 = this.getScaled();
        this.gui.drawFluid(this.posX, this.posY + this.sizeY - n3, this.tank.getFluid(), this.sizeX, n3);
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 32 + this.gaugeType * 16, 1, this.sizeX, this.sizeY);
    }

    @Override
    public void drawForeground(int n, int n2) {
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            list.add(StringHelper.getFluidName(this.tank.getFluid()));
        }
        if (this.tank.getCapacity() < 0) {
            list.add("Infinite Fluid");
        } else {
            list.add("" + this.tank.getFluidAmount() + " / " + this.tank.getCapacity() + " mB");
        }
    }

    protected int getScaled() {
        if (this.tank.getCapacity() < 0) {
            return this.sizeY;
        }
        long l = (long)this.tank.getFluidAmount() * (long)this.sizeY / (long)this.tank.getCapacity();
        return this.alwaysShowMinimum && this.tank.getFluidAmount() > 0 ? Math.max(1, MathHelper.round(l)) : MathHelper.round(l);
    }
}

