/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import com.destroystokyo.paper.network.StatusClient;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;

public class PaperServerListPingEvent
extends ServerListPingEvent
implements Cancellable {
    @Nonnull
    private final StatusClient client;
    private int numPlayers;
    private boolean hidePlayers;
    @Nonnull
    private final List<PlayerProfile> playerSample = new ArrayList<PlayerProfile>();
    @Nonnull
    private String version;
    private int protocolVersion;
    @Nullable
    private CachedServerIcon favicon;
    private boolean cancelled;
    private boolean originalPlayerCount = true;
    private Object[] players;

    public PaperServerListPingEvent(@Nonnull StatusClient client, String motd, int numPlayers, int maxPlayers, @Nonnull String version, int protocolVersion, @Nullable CachedServerIcon favicon) {
        super(client.getAddress().getAddress(), motd, numPlayers, maxPlayers);
        this.client = client;
        this.numPlayers = numPlayers;
        this.version = version;
        this.protocolVersion = protocolVersion;
        this.setServerIcon(favicon);
    }

    @Nonnull
    public StatusClient getClient() {
        return this.client;
    }

    @Override
    public int getNumPlayers() {
        if (this.hidePlayers) {
            return -1;
        }
        return this.numPlayers;
    }

    public void setNumPlayers(int numPlayers) {
        if (this.numPlayers != numPlayers) {
            this.numPlayers = numPlayers;
            this.originalPlayerCount = false;
        }
    }

    @Override
    public int getMaxPlayers() {
        if (this.hidePlayers) {
            return -1;
        }
        return super.getMaxPlayers();
    }

    public boolean shouldHidePlayers() {
        return this.hidePlayers;
    }

    public void setHidePlayers(boolean hidePlayers) {
        this.hidePlayers = hidePlayers;
    }

    @Nonnull
    public List<PlayerProfile> getPlayerSample() {
        return this.playerSample;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull String version) {
        this.version = Objects.requireNonNull(version, "version");
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Nullable
    public CachedServerIcon getServerIcon() {
        return this.favicon;
    }

    @Override
    public void setServerIcon(@Nullable CachedServerIcon icon) {
        if (icon != null && icon.isEmpty()) {
            icon = null;
        }
        this.favicon = icon;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @Nonnull
    public Iterator<Player> iterator() {
        if (this.players == null) {
            this.players = this.getOnlinePlayers();
        }
        return new PlayerIterator();
    }

    protected Object[] getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().toArray();
    }

    protected Player getBukkitPlayer(Object player) {
        return (Player)player;
    }

    @Deprecated
    public List<String> getSampleText() {
        ArrayList<String> sampleText = new ArrayList<String>();
        for (PlayerProfile profile : this.getPlayerSample()) {
            sampleText.add(Strings.nullToEmpty(profile.getName()));
        }
        return sampleText;
    }

    @Deprecated
    public void setSampleText(List<String> sample) {
        this.getPlayerSample().clear();
        for (String name : sample) {
            this.getPlayerSample().add(Bukkit.createProfile(name));
        }
    }

    private final class PlayerIterator
    implements Iterator<Player> {
        private int next;
        private int current;
        @Nullable
        private Player player;

        private PlayerIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.next < PaperServerListPingEvent.this.players.length) {
                if (PaperServerListPingEvent.this.players[this.next] != null) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        public Player next() {
            if (!this.hasNext()) {
                this.player = null;
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.player = PaperServerListPingEvent.this.getBukkitPlayer(PaperServerListPingEvent.this.players[this.current]);
            return this.player;
        }

        @Override
        public void remove() {
            if (this.player == null) {
                throw new IllegalStateException();
            }
            UUID uniqueId = this.player.getUniqueId();
            this.player = null;
            ((PaperServerListPingEvent)PaperServerListPingEvent.this).players[this.current] = null;
            PaperServerListPingEvent.this.getPlayerSample().removeIf(p -> uniqueId.equals(p.getId()));
            if (PaperServerListPingEvent.this.originalPlayerCount) {
                PaperServerListPingEvent.this.numPlayers--;
            }
        }
    }
}

