/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.network.PaperServerListPingEventImpl;
import com.destroystokyo.paper.network.PaperStatusClient;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;

public final class StandardPaperServerListPingEventImpl
extends PaperServerListPingEventImpl {
    private static final GameProfile[] EMPTY_PROFILES = new GameProfile[0];
    private static final UUID FAKE_UUID = new UUID(0L, 0L);
    private GameProfile[] originalSample;

    private StandardPaperServerListPingEventImpl(MinecraftServer server, gw networkManager, mt ping) {
        super(server, new PaperStatusClient(networkManager), ping.c() != null ? ping.c().b() : -1, server.server.getServerIcon());
        this.originalSample = ping.b() == null ? null : ping.b().c();
    }

    @Override
    @Nonnull
    public List<PlayerProfile> getPlayerSample() {
        List<PlayerProfile> sample = super.getPlayerSample();
        if (this.originalSample != null) {
            for (GameProfile profile : this.originalSample) {
                sample.add(CraftPlayerProfile.asBukkitCopy(profile));
            }
            this.originalSample = null;
        }
        return sample;
    }

    private GameProfile[] getPlayerSampleHandle() {
        if (this.originalSample != null) {
            return this.originalSample;
        }
        List<PlayerProfile> entries = super.getPlayerSample();
        if (entries.isEmpty()) {
            return EMPTY_PROFILES;
        }
        GameProfile[] profiles = new GameProfile[entries.size()];
        for (int i2 = 0; i2 < profiles.length; ++i2) {
            PlayerProfile profile = entries.get(i2);
            profiles[i2] = profile.getId() != null && profile.getName() != null ? CraftPlayerProfile.asAuthlib(profile) : new GameProfile(MoreObjects.firstNonNull(profile.getId(), FAKE_UUID), Strings.nullToEmpty(profile.getName()));
        }
        return profiles;
    }

    public static void processRequest(MinecraftServer server, gw networkManager) {
        StandardPaperServerListPingEventImpl event = new StandardPaperServerListPingEventImpl(server, networkManager, server.aC());
        server.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            networkManager.a((hh)null);
            return;
        }
        mt ping = new mt();
        ping.a(new ho(event.getMotd()));
        if (!event.shouldHidePlayers()) {
            ping.a(new mt.a(event.getMaxPlayers(), event.getNumPlayers()));
            ping.b().a(event.getPlayerSampleHandle());
        }
        ping.a(new mt.c(event.getVersion(), event.getProtocolVersion()));
        if (event.getServerIcon() != null) {
            ping.a(event.getServerIcon().getData());
        }
        networkManager.a(new ms(ping));
    }
}

