/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProfileProperty {
    private final String name;
    private final String value;
    private final String signature;

    public ProfileProperty(@Nonnull String name, @Nonnull String value) {
        this(name, value, null);
    }

    public ProfileProperty(@Nonnull String name, @Nonnull String value, @Nullable String signature) {
        this.name = Preconditions.checkNotNull(name, "ProfileProperty name can not be null");
        this.value = Preconditions.checkNotNull(value, "ProfileProperty value can not be null");
        this.signature = signature;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileProperty that = (ProfileProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

