/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public final class ItemTextureQuadConverter {
    private ItemTextureQuadConverter() {
    }

    @Deprecated
    public static List<UnpackedBakedQuad> convertTexture(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color) {
        return ItemTextureQuadConverter.convertTexture(format, transform, template, sprite, z, facing, color, -1);
    }

    public static List<UnpackedBakedQuad> convertTexture(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color, int tint) {
        List<UnpackedBakedQuad> horizontal = ItemTextureQuadConverter.convertTextureHorizontal(format, transform, template, sprite, z, facing, color, tint);
        List<UnpackedBakedQuad> vertical = ItemTextureQuadConverter.convertTextureVertical(format, transform, template, sprite, z, facing, color, tint);
        return horizontal.size() <= vertical.size() ? horizontal : vertical;
    }

    @Deprecated
    public static List<UnpackedBakedQuad> convertTextureHorizontal(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color) {
        return ItemTextureQuadConverter.convertTextureHorizontal(format, transform, template, sprite, z, facing, color, -1);
    }

    public static List<UnpackedBakedQuad> convertTextureHorizontal(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color, int tint) {
        int w = template.c();
        int h2 = template.d();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h2;
        int[] data = template.a(0)[0];
        ArrayList<UnpackedBakedQuad> quads = Lists.newArrayList();
        int start = -1;
        for (int y = 0; y < h2; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = data[y * w + x];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = x;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endY = y + 1;
                boolean sameRow = true;
                while (sameRow && endY < h2) {
                    for (int i2 = 0; i2 < w; ++i2) {
                        int px1 = data[y * w + i2];
                        int px2 = data[endY * w + i2];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameRow = false;
                        break;
                    }
                    if (!sameRow) continue;
                    ++endY;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)start * wScale, (float)y * hScale, (float)x * wScale, (float)endY * hScale, z, sprite, facing, color, tint));
                if (endY - y > 1) {
                    y = endY - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    @Deprecated
    public static List<UnpackedBakedQuad> convertTextureVertical(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color) {
        return ItemTextureQuadConverter.convertTextureVertical(format, transform, template, sprite, z, facing, color, -1);
    }

    public static List<UnpackedBakedQuad> convertTextureVertical(cea format, TRSRTransformation transform, cdq template, cdq sprite, float z, fa facing, int color, int tint) {
        int w = template.c();
        int h2 = template.d();
        float wScale = 16.0f / (float)w;
        float hScale = 16.0f / (float)h2;
        int[] data = template.a(0)[0];
        ArrayList<UnpackedBakedQuad> quads = Lists.newArrayList();
        int start = -1;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h2; ++y) {
                int pixel = data[y * w + x];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = y;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endX = x + 1;
                boolean sameColumn = true;
                while (sameColumn && endX < w) {
                    for (int i2 = 0; i2 < h2; ++i2) {
                        int px1 = data[i2 * w + x];
                        int px2 = data[i2 * w + endX];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameColumn = false;
                        break;
                    }
                    if (!sameColumn) continue;
                    ++endX;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, (float)x * wScale, (float)start * hScale, (float)endX * wScale, (float)y * hScale, z, sprite, facing, color, tint));
                if (endX - x > 1) {
                    x = endX - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    private static boolean isVisible(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f > 0.1f;
    }

    @Deprecated
    public static UnpackedBakedQuad genQuad(cea format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z, cdq sprite, fa facing, int color) {
        return ItemTextureQuadConverter.genQuad(format, transform, x1, y1, x2, y2, z, sprite, facing, color, -1);
    }

    public static UnpackedBakedQuad genQuad(cea format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z, cdq sprite, fa facing, int color, int tint) {
        float u1 = sprite.a((double)x1);
        float v1 = sprite.b((double)y1);
        float u2 = sprite.a((double)x2);
        float v2 = sprite.b((double)y2);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return ItemTextureQuadConverter.putQuad(format, transform, facing, sprite, color, tint, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z, u1, v1, u2, v2);
    }

    private static UnpackedBakedQuad putQuad(cea format, TRSRTransformation transform, fa side, cdq sprite, int color, int tint, float x1, float y1, float x2, float y2, float z, float u1, float v1, float u2, float v2) {
        IVertexConsumer consumer;
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        boolean hasTransform = !transform.isIdentity();
        IVertexConsumer iVertexConsumer = consumer = hasTransform ? new TRSRTransformer(builder, transform) : builder;
        if (side == fa.d) {
            ItemTextureQuadConverter.putVertex(consumer, format, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x2, y1, z, u2, v2, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x1, y2, z, u1, v1, color);
        } else {
            ItemTextureQuadConverter.putVertex(consumer, format, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x1, y2, z, u1, v1, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(consumer, format, side, x2, y1, z, u2, v2, color);
        }
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, cea format, fa side, float x, float y, float z, float u, float v, int color) {
        block6: for (int e = 0; e < format.i(); ++e) {
            switch (format.c(e).b()) {
                case a: {
                    consumer.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case c: {
                    float r2 = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
                    consumer.put(e, r2, g, b2, a2);
                    continue block6;
                }
                case b: {
                    float offX = side.g();
                    float offY = side.h();
                    float offZ = side.i();
                    consumer.put(e, offX, offY, offZ, 0.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e).d() == 0) {
                        consumer.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }
}

