/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import java.util.Optional;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelStateComposition
implements IModelState {
    private final IModelState first;
    private final IModelState second;

    public ModelStateComposition(IModelState first, IModelState second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        Optional<TRSRTransformation> f = this.first.apply(part);
        Optional<TRSRTransformation> s = this.second.apply(part);
        if (f.isPresent() && s.isPresent()) {
            return Optional.of(f.get().compose(s.get()));
        }
        if (f.isPresent()) {
            return f;
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelStateComposition that = (ModelStateComposition)o;
        return Objects.equal(this.first, that.first) && Objects.equal(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hashCode(this.first, this.second);
    }
}

