/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModel {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel(ImmutableMap.of());
    private final ImmutableMap<Optional<amm>, cgd> models;

    public MultiLayerModel(ImmutableMap<Optional<amm>, cgd> models) {
        this.models = models;
    }

    @Override
    public Collection<nf> getDependencies() {
        return ImmutableList.copyOf(this.models.values());
    }

    private static ImmutableMap<Optional<amm>, cfy> buildModels(ImmutableMap<Optional<amm>, cgd> models, IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        ImmutableMap.Builder<Optional, cfy> builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((nf)models.get(key), "Couldn't load MultiLayerModel dependency: " + models.get(key));
            builder.put(key, model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), PerspectiveMapWrapper.getTransforms(state));
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put(Optional.empty(), this.getLocation(customData.get(key)));
            }
            for (amm layer : amm.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put(Optional.of(layer), this.getLocation(customData.get(key)));
            }
        }
        ImmutableMap<Optional<amm>, cgd> models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel(models);
    }

    private cgd getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new cgd(e.getAsString());
        }
        FMLLog.log.fatal("Expect ModelResourceLocation, got: {}", (Object)json);
        return new cgd("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void a(cep resourceManager) {
        }

        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(nf modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements cfy {
        private final ImmutableMap<Optional<amm>, cfy> models;
        private final ImmutableMap<bwc.b, TRSRTransformation> cameraTransforms;
        private final cfy base;
        private final cfy missing;

        public MultiLayerBakedModel(ImmutableMap<Optional<amm>, cfy> models, cfy missing, ImmutableMap<bwc.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.getOrDefault(Optional.empty(), missing);
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            amm layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (cfy model : this.models.values()) {
                    builder.addAll((Iterable)model.a(state, side, rand));
                }
                return builder.build();
            }
            return this.models.getOrDefault(Optional.of(layer), this.missing).a(state, side, rand);
        }

        public boolean a() {
            return this.base.a();
        }

        public boolean isAmbientOcclusion(awt state) {
            return this.base.isAmbientOcclusion(state);
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public cdq d() {
            return this.base.d();
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((cfy)this, this.cameraTransforms, cameraTransformType);
        }

        public bwa f() {
            return bwa.a;
        }
    }
}

