/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PerspectiveMapWrapper
implements cfy {
    private final cfy parent;
    private final ImmutableMap<bwc.b, TRSRTransformation> transforms;

    public PerspectiveMapWrapper(cfy parent, ImmutableMap<bwc.b, TRSRTransformation> transforms) {
        this.parent = parent;
        this.transforms = transforms;
    }

    public PerspectiveMapWrapper(cfy parent, IModelState state) {
        this(parent, PerspectiveMapWrapper.getTransforms(state));
    }

    public static ImmutableMap<bwc.b, TRSRTransformation> getTransforms(IModelState state) {
        EnumMap<bwc.b, TRSRTransformation> map = new EnumMap<bwc.b, TRSRTransformation>(bwc.b.class);
        for (bwc.b type : bwc.b.values()) {
            Optional<TRSRTransformation> tr2 = state.apply(Optional.of(type));
            if (!tr2.isPresent()) continue;
            map.put(type, tr2.get());
        }
        return ImmutableMap.copyOf(map);
    }

    public static ImmutableMap<bwc.b, TRSRTransformation> getTransforms(bwc transforms) {
        EnumMap<bwc.b, TRSRTransformation> map = new EnumMap<bwc.b, TRSRTransformation>(bwc.b.class);
        for (bwc.b type : bwc.b.values()) {
            if (!transforms.c(type)) continue;
            map.put(type, TRSRTransformation.blockCenterToCorner(TRSRTransformation.from(transforms.b(type))));
        }
        return ImmutableMap.copyOf(map);
    }

    public static Pair<? extends cfy, Matrix4f> handlePerspective(cfy model, ImmutableMap<bwc.b, TRSRTransformation> transforms, bwc.b cameraTransformType) {
        TRSRTransformation tr2 = transforms.getOrDefault(cameraTransformType, TRSRTransformation.identity());
        if (!tr2.isIdentity()) {
            return Pair.of(model, TRSRTransformation.blockCornerToCenter(tr2).getMatrix());
        }
        return Pair.of(model, null);
    }

    public static Pair<? extends cfy, Matrix4f> handlePerspective(cfy model, IModelState state, bwc.b cameraTransformType) {
        TRSRTransformation tr2 = state.apply(Optional.of(cameraTransformType)).orElse(TRSRTransformation.identity());
        if (!tr2.isIdentity()) {
            return Pair.of(model, TRSRTransformation.blockCornerToCenter(tr2).getMatrix());
        }
        return Pair.of(model, null);
    }

    public boolean a() {
        return this.parent.a();
    }

    public boolean isAmbientOcclusion(awt state) {
        return this.parent.isAmbientOcclusion(state);
    }

    public boolean b() {
        return this.parent.b();
    }

    public boolean c() {
        return this.parent.c();
    }

    public cdq d() {
        return this.parent.d();
    }

    public bwc e() {
        return this.parent.e();
    }

    public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
        return this.parent.a(state, side, rand);
    }

    public bwa f() {
        return this.parent.f();
    }

    public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((cfy)this, this.transforms, cameraTransformType);
    }
}

