/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import org.apache.commons.lang3.tuple.Pair;

public class LightUtil {
    private static final ConcurrentMap<Pair<cea, cea>, int[]> formatMaps = new ConcurrentHashMap<Pair<cea, cea>, int[]>();
    private static final cea DEFAULT_FROM = VertexLighterFlat.withNormal(cdy.a);
    private static final cea DEFAULT_TO = cdy.b;
    private static final int[] DEFAULT_MAPPING = LightUtil.generateMapping(DEFAULT_FROM, DEFAULT_TO);
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;
    private static final ThreadLocal<ItemPipeline> itemPipeline = ThreadLocal.withInitial(ItemPipeline::new);

    public static float diffuseLight(float x, float y, float z) {
        return Math.min(x * x * 0.6f + y * y * ((3.0f + y) / 4.0f) + z * z * 0.8f, 1.0f);
    }

    public static float diffuseLight(fa side) {
        switch (side) {
            case a: {
                return 0.5f;
            }
            case b: {
                return 1.0f;
            }
            case c: 
            case d: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static fa toSide(float x, float y, float z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0f) {
                    return fa.e;
                }
                return fa.f;
            }
            if (z < 0.0f) {
                return fa.c;
            }
            return fa.d;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return fa.a;
            }
            return fa.b;
        }
        if (z < 0.0f) {
            return fa.c;
        }
        return fa.d;
    }

    public static void putBakedQuad(IVertexConsumer consumer, bvp quad) {
        consumer.setTexture(quad.a());
        consumer.setQuadOrientation(quad.e());
        if (quad.c()) {
            consumer.setQuadTint(quad.d());
        }
        consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        cea formatFrom = consumer.getVertexFormat();
        cea formatTo = quad.getFormat();
        int countFrom = formatFrom.i();
        int countTo = formatTo.i();
        int[] eMap = LightUtil.mapFormats(formatFrom, formatTo);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack(quad.b(), data, formatTo, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(cea from, cea to) {
        if (from.equals((Object)DEFAULT_FROM) && to.equals((Object)DEFAULT_TO)) {
            return DEFAULT_MAPPING;
        }
        return formatMaps.computeIfAbsent(Pair.of(from, to), pair -> LightUtil.generateMapping((cea)pair.getLeft(), (cea)pair.getRight()));
    }

    private static int[] generateMapping(cea from, cea to) {
        int fromCount = from.i();
        int toCount = to.i();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            ceb expected = from.c(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                ceb current = to.c(e2);
                if (expected.b() == current.b() && expected.d() == current.d()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, cea formatFrom, int v, int e) {
        int length = 4 < to.length ? 4 : to.length;
        ceb element = formatFrom.c(e);
        int vertexStart = v * formatFrom.g() + formatFrom.d(e);
        int count = element.c();
        ceb.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i2 = 0; i2 < length; ++i2) {
            if (i2 < count) {
                int pos = vertexStart + size * i2;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == ceb.a.a) {
                    to[i2] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == ceb.a.b || type == ceb.a.d) {
                    to[i2] = (float)bits / (float)mask;
                    continue;
                }
                if (type == ceb.a.f) {
                    to[i2] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == ceb.a.c) {
                    to[i2] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == ceb.a.e) {
                    to[i2] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != ceb.a.g) continue;
                to[i2] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i2] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, cea formatTo, int v, int e) {
        ceb element = formatTo.c(e);
        int vertexStart = v * formatTo.g() + formatTo.d(e);
        int count = element.c();
        ceb.a type = element.a();
        int size = type.a();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f;
            if (i2 >= count) continue;
            int pos = vertexStart + size * i2;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i2 < from.length ? from[i2] : 0.0f;
            bits = type == ceb.a.a ? Float.floatToRawIntBits(f) : (type == ceb.a.b || type == ceb.a.d || type == ceb.a.f ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    @Deprecated
    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            bve tes = bve.a();
            buk wr = tes.c();
            tessellator = new VertexBufferConsumer(wr);
        }
        return tessellator;
    }

    @Deprecated
    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(buk buffer, bvp quad, int auxColor) {
        ItemPipeline pipeline = itemPipeline.get();
        pipeline.bufferConsumer.setBuffer(buffer);
        ItemConsumer cons = pipeline.itemConsumer;
        float b2 = (float)(auxColor & 0xFF) / 255.0f;
        float g = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r2 = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a2 = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r2, g, b2, a2);
        quad.pipe((IVertexConsumer)cons);
    }

    public static void renderQuadColor(buk buffer, bvp quad, int auxColor) {
        if (quad.getFormat().equals((Object)buffer.g())) {
            buffer.a(quad.b());
            if (buffer.g().d()) {
                ForgeHooksClient.putQuadColor(buffer, quad, auxColor);
            }
        } else {
            LightUtil.renderQuadColorSlow(buffer, quad, auxColor);
        }
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().c(element).b() == ceb.b.c) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                int n = Math.min(4, data.length);
                for (int i2 = 0; i2 < n; ++i2) {
                    int n2 = i2;
                    this.buf[n2] = this.buf[n2] * data[i2];
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().i() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                }
            }
        }
    }

    private static final class ItemPipeline {
        final VertexBufferConsumer bufferConsumer = new VertexBufferConsumer();
        final ItemConsumer itemConsumer = new ItemConsumer(this.bufferConsumer);

        ItemPipeline() {
        }
    }
}

