/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.animation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.common.animation.ITimeValue;

public final class TimeValues {

    public static enum CommonTimeValueTypeAdapterFactory implements TypeAdapterFactory
    {
        INSTANCE;

        private final ThreadLocal<Function<String, ITimeValue>> valueResolver = new ThreadLocal();

        public void setValueResolver(@Nullable Function<String, ITimeValue> valueResolver) {
            this.valueResolver.set(valueResolver);
        }

        @Override
        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != ITimeValue.class) {
                return null;
            }
            return new TypeAdapter<ITimeValue>(){

                @Override
                public void write(JsonWriter out, ITimeValue parameter) throws IOException {
                    if (parameter instanceof ConstValue) {
                        out.value(((ConstValue)parameter).output);
                    } else if (parameter instanceof SimpleExprValue) {
                        SimpleExprValue p2 = (SimpleExprValue)parameter;
                        out.beginArray();
                        out.value(p2.operators);
                        for (ITimeValue v : p2.args) {
                            this.write(out, v);
                        }
                        out.endArray();
                    } else if (parameter instanceof CompositionValue) {
                        CompositionValue p3 = (CompositionValue)parameter;
                        out.beginArray();
                        out.value("compose");
                        this.write(out, p3.g);
                        this.write(out, p3.f);
                        out.endArray();
                    } else if (parameter instanceof ro) {
                        out.value("#" + ((ro)((Object)parameter)).m());
                    }
                }

                @Override
                public ITimeValue read(JsonReader in) throws IOException {
                    switch (in.peek()) {
                        case NUMBER: {
                            return new ConstValue((float)in.nextDouble());
                        }
                        case BEGIN_ARRAY: {
                            ITimeValue p2;
                            in.beginArray();
                            String type = in.nextString();
                            if (SimpleExprValue.opsPattern.matcher(type).matches()) {
                                ImmutableList.Builder builder = ImmutableList.builder();
                                while (in.hasNext()) {
                                    builder.add(this.read(in));
                                }
                                p2 = new SimpleExprValue(type, (ImmutableList<ITimeValue>)builder.build());
                            } else if ("compose".equals(type)) {
                                p2 = new CompositionValue(this.read(in), this.read(in));
                            } else {
                                throw new IOException("Unknown TimeValue type \"" + type + "\"");
                            }
                            in.endArray();
                            return p2;
                        }
                        case STRING: {
                            String string = in.nextString();
                            if (string.equals("#identity")) {
                                return IdentityValue.INSTANCE;
                            }
                            if (!string.startsWith("#")) {
                                throw new IOException("Expected TimeValue reference, got \"" + string + "\"");
                            }
                            return new ParameterValue(string.substring(1), (Function)valueResolver.get());
                        }
                    }
                    throw new IOException("Expected TimeValue, got " + (Object)((Object)in.peek()));
                }
            };
        }
    }

    public static final class ParameterValue
    implements ITimeValue,
    ro {
        private final String parameterName;
        private final Function<String, ITimeValue> valueResolver;
        private ITimeValue parameter;

        public ParameterValue(String parameterName, Function<String, ITimeValue> valueResolver) {
            this.parameterName = parameterName;
            this.valueResolver = valueResolver;
        }

        @Override
        public String m() {
            return this.parameterName;
        }

        private void resolve() {
            if (this.parameter == null) {
                if (this.valueResolver != null) {
                    this.parameter = this.valueResolver.apply(this.parameterName);
                }
                if (this.parameter == null) {
                    throw new IllegalArgumentException("Couldn't resolve parameter value " + this.parameterName);
                }
            }
        }

        @Override
        public float apply(float input) {
            this.resolve();
            return this.parameter.apply(input);
        }

        public int hashCode() {
            this.resolve();
            return this.parameter.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterValue other = (ParameterValue)obj;
            this.resolve();
            other.resolve();
            return Objects.equal(this.parameter, other.parameter);
        }
    }

    public static final class CompositionValue
    implements ITimeValue {
        private final ITimeValue g;
        private final ITimeValue f;

        public CompositionValue(ITimeValue g, ITimeValue f) {
            this.g = g;
            this.f = f;
        }

        @Override
        public float apply(float input) {
            return this.g.apply(this.f.apply(input));
        }

        public int hashCode() {
            return Objects.hashCode(this.g, this.f);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositionValue other = (CompositionValue)obj;
            return Objects.equal(this.g, other.g) && Objects.equal(this.f, other.f);
        }
    }

    public static final class SimpleExprValue
    implements ITimeValue {
        private static final Pattern opsPattern = Pattern.compile("[+\\-*/mMrRfF]+");
        private final String operators;
        private final ImmutableList<ITimeValue> args;

        public SimpleExprValue(String operators, ImmutableList<ITimeValue> args) {
            this.operators = operators;
            this.args = args;
        }

        @Override
        public float apply(float input) {
            float ret = input;
            block12: for (int i2 = 0; i2 < this.operators.length(); ++i2) {
                float arg = ((ITimeValue)this.args.get(i2)).apply(input);
                switch (this.operators.charAt(i2)) {
                    case '+': {
                        ret += arg;
                        continue block12;
                    }
                    case '-': {
                        ret -= arg;
                        continue block12;
                    }
                    case '*': {
                        ret *= arg;
                        continue block12;
                    }
                    case '/': {
                        ret /= arg;
                        continue block12;
                    }
                    case 'm': {
                        ret = Math.min(ret, arg);
                        continue block12;
                    }
                    case 'M': {
                        ret = Math.max(ret, arg);
                        continue block12;
                    }
                    case 'r': {
                        ret = (float)Math.floor(ret / arg) * arg;
                        continue block12;
                    }
                    case 'R': {
                        ret = (float)Math.ceil(ret / arg) * arg;
                        continue block12;
                    }
                    case 'f': {
                        ret = (float)((double)ret - Math.floor(ret / arg) * (double)arg);
                        continue block12;
                    }
                    case 'F': {
                        ret = (float)Math.ceil(ret / arg) * arg - ret;
                    }
                }
            }
            return ret;
        }

        public int hashCode() {
            return Objects.hashCode(this.operators, this.args);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleExprValue other = (SimpleExprValue)obj;
            return Objects.equal(this.operators, other.operators) && Objects.equal(this.args, other.args);
        }
    }

    public static final class VariableValue
    implements ITimeValue {
        private float output;

        public VariableValue(float initialValue) {
            this.output = initialValue;
        }

        public void setValue(float newValue) {
            this.output = newValue;
        }

        @Override
        public float apply(float input) {
            return this.output;
        }

        public int hashCode() {
            return Objects.hashCode(Float.valueOf(this.output));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableValue other = (VariableValue)obj;
            return this.output == other.output;
        }
    }

    public static final class ConstValue
    implements ITimeValue {
        private final float output;

        public ConstValue(float output) {
            this.output = output;
        }

        @Override
        public float apply(float input) {
            return this.output;
        }

        public int hashCode() {
            return Objects.hashCode(Float.valueOf(this.output));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstValue other = (ConstValue)obj;
            return this.output == other.output;
        }
    }

    public static enum IdentityValue implements ITimeValue,
    ro
    {
        INSTANCE;


        @Override
        public float apply(float input) {
            return input;
        }

        @Override
        public String m() {
            return "identity";
        }
    }
}

