/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ConfigElement
implements IConfigElement {
    private Property prop;
    private Property.Type type;
    private boolean isProperty;
    private ConfigCategory category;
    private boolean categoriesFirst = true;

    public ConfigElement(ConfigCategory category) {
        this.category = category;
        this.isProperty = false;
    }

    public ConfigElement(Property prop) {
        this.prop = prop;
        this.type = prop.getType();
        this.isProperty = true;
    }

    public ConfigElement listCategoriesFirst(boolean categoriesFirst) {
        this.categoriesFirst = categoriesFirst;
        return this;
    }

    @Override
    public List<IConfigElement> getChildElements() {
        if (!this.isProperty) {
            ConfigElement temp;
            ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
            Iterator<ConfigCategory> ccI = this.category.getChildren().iterator();
            Iterator<Property> pI = this.category.getOrderedValues().iterator();
            boolean index = false;
            if (this.categoriesFirst) {
                while (ccI.hasNext()) {
                    temp = new ConfigElement(ccI.next());
                    if (!temp.showInGui()) continue;
                    elements.add(temp);
                }
            }
            while (pI.hasNext()) {
                temp = new ConfigElement(pI.next());
                if (!temp.showInGui()) continue;
                elements.add(temp);
            }
            if (!this.categoriesFirst) {
                while (ccI.hasNext()) {
                    temp = new ConfigElement(ccI.next());
                    if (!temp.showInGui()) continue;
                    elements.add(temp);
                }
            }
            return elements;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.isProperty ? this.prop.getName() : this.category.getName();
    }

    @Override
    public boolean isProperty() {
        return this.isProperty;
    }

    @Override
    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.isProperty ? this.prop.getConfigEntryClass() : this.category.getConfigEntryClass();
    }

    @Override
    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.isProperty ? this.prop.getArrayEntryClass() : null;
    }

    @Override
    public String getQualifiedName() {
        return this.isProperty ? this.prop.getName() : this.category.getQualifiedName();
    }

    @Override
    public ConfigGuiType getType() {
        return this.isProperty ? ConfigElement.getType(this.prop) : ConfigGuiType.CONFIG_CATEGORY;
    }

    public static ConfigGuiType getType(Property prop) {
        return prop.getType() == Property.Type.BOOLEAN ? ConfigGuiType.BOOLEAN : (prop.getType() == Property.Type.DOUBLE ? ConfigGuiType.DOUBLE : (prop.getType() == Property.Type.INTEGER ? ConfigGuiType.INTEGER : (prop.getType() == Property.Type.COLOR ? ConfigGuiType.COLOR : (prop.getType() == Property.Type.MOD_ID ? ConfigGuiType.MOD_ID : ConfigGuiType.STRING))));
    }

    @Override
    public boolean isList() {
        return this.isProperty && this.prop.isList();
    }

    @Override
    public boolean isListLengthFixed() {
        return this.isProperty && this.prop.isListLengthFixed();
    }

    @Override
    public int getMaxListLength() {
        return this.isProperty ? this.prop.getMaxListLength() : -1;
    }

    @Override
    public String getComment() {
        return this.isProperty ? this.prop.getComment() : this.category.getComment();
    }

    @Override
    public boolean isDefault() {
        return !this.isProperty || this.prop.isDefault();
    }

    @Override
    public void setToDefault() {
        if (this.isProperty) {
            this.prop.setToDefault();
        }
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.isProperty ? this.prop.requiresWorldRestart() : this.category.requiresWorldRestart();
    }

    @Override
    public boolean showInGui() {
        return this.isProperty ? this.prop.showInGui() : this.category.showInGui();
    }

    @Override
    public boolean requiresMcRestart() {
        return this.isProperty ? this.prop.requiresMcRestart() : this.category.requiresMcRestart();
    }

    @Override
    public String[] getValidValues() {
        return this.isProperty ? this.prop.getValidValues() : null;
    }

    @Override
    public String[] getValidValuesDisplay() {
        return this.isProperty ? this.prop.getValidValuesDisplay() : null;
    }

    @Override
    public String getLanguageKey() {
        return this.isProperty ? this.prop.getLanguageKey() : this.category.getLanguagekey();
    }

    @Override
    public Object getDefault() {
        return this.isProperty ? this.prop.getDefault() : null;
    }

    @Override
    public Object[] getDefaults() {
        if (this.isProperty) {
            Object[] aVal = this.prop.getDefaults();
            if (this.type == Property.Type.BOOLEAN) {
                Object[] ba = new Boolean[aVal.length];
                for (int i2 = 0; i2 < aVal.length; ++i2) {
                    ba[i2] = Boolean.valueOf((String)aVal[i2]);
                }
                return ba;
            }
            if (this.type == Property.Type.DOUBLE) {
                Object[] da = new Double[aVal.length];
                for (int i3 = 0; i3 < aVal.length; ++i3) {
                    da[i3] = Double.valueOf(((String)aVal[i3]).toString());
                }
                return da;
            }
            if (this.type == Property.Type.INTEGER) {
                Object[] ia = new Integer[aVal.length];
                for (int i4 = 0; i4 < aVal.length; ++i4) {
                    ia[i4] = Integer.valueOf(((String)aVal[i4]).toString());
                }
                return ia;
            }
            return aVal;
        }
        return null;
    }

    @Override
    public Pattern getValidationPattern() {
        return this.isProperty ? this.prop.getValidationPattern() : null;
    }

    @Override
    public Object get() {
        return this.isProperty ? this.prop.getString() : null;
    }

    @Override
    public Object[] getList() {
        if (this.isProperty) {
            Object[] aVal = this.prop.getStringList();
            if (this.type == Property.Type.BOOLEAN) {
                Object[] ba = new Boolean[aVal.length];
                for (int i2 = 0; i2 < aVal.length; ++i2) {
                    ba[i2] = Boolean.valueOf((String)aVal[i2]);
                }
                return ba;
            }
            if (this.type == Property.Type.DOUBLE) {
                Object[] da = new Double[aVal.length];
                for (int i3 = 0; i3 < aVal.length; ++i3) {
                    da[i3] = Double.valueOf(((String)aVal[i3]).toString());
                }
                return da;
            }
            if (this.type == Property.Type.INTEGER) {
                Object[] ia = new Integer[aVal.length];
                for (int i4 = 0; i4 < aVal.length; ++i4) {
                    ia[i4] = Integer.valueOf(((String)aVal[i4]).toString());
                }
                return ia;
            }
            return aVal;
        }
        return null;
    }

    @Override
    public void set(Object value) {
        if (this.isProperty) {
            if (this.type == Property.Type.BOOLEAN) {
                this.prop.set(Boolean.parseBoolean(value.toString()));
            } else if (this.type == Property.Type.DOUBLE) {
                this.prop.set(Double.parseDouble(value.toString()));
            } else if (this.type == Property.Type.INTEGER) {
                this.prop.set(Integer.parseInt(value.toString()));
            } else {
                this.prop.set(value.toString());
            }
        }
    }

    @Override
    public void set(Object[] aVal) {
        if (this.isProperty) {
            if (this.type == Property.Type.BOOLEAN) {
                boolean[] ba = new boolean[aVal.length];
                for (int i2 = 0; i2 < aVal.length; ++i2) {
                    ba[i2] = Boolean.valueOf(aVal[i2].toString());
                }
                this.prop.set(ba);
            } else if (this.type == Property.Type.DOUBLE) {
                double[] da = new double[aVal.length];
                for (int i3 = 0; i3 < aVal.length; ++i3) {
                    da[i3] = Double.valueOf(aVal[i3].toString());
                }
                this.prop.set(da);
            } else if (this.type == Property.Type.INTEGER) {
                int[] ia = new int[aVal.length];
                for (int i4 = 0; i4 < aVal.length; ++i4) {
                    ia[i4] = Integer.valueOf(aVal[i4].toString());
                }
                this.prop.set(ia);
            } else {
                String[] is = new String[aVal.length];
                for (int i5 = 0; i5 < aVal.length; ++i5) {
                    is[i5] = aVal[i5].toString();
                }
                this.prop.set(is);
            }
        }
    }

    @Override
    public Object getMinValue() {
        return this.isProperty ? this.prop.getMinValue() : null;
    }

    @Override
    public Object getMaxValue() {
        return this.isProperty ? this.prop.getMaxValue() : null;
    }

    @Override
    public boolean hasSlidingControl() {
        return this.prop.hasSlidingControl();
    }

    public static IConfigElement from(Class<?> configClass) {
        String name;
        Config annotation = configClass.getAnnotation(Config.class);
        if (annotation == null) {
            throw new RuntimeException(String.format("The class '%s' has no @Config annotation!", configClass.getName()));
        }
        Configuration config = ConfigManager.getConfiguration(annotation.modid(), annotation.name());
        if (config == null) {
            String error = String.format("The configuration '%s' of mod '%s' isn't loaded with the ConfigManager!", annotation.name(), annotation.modid());
            throw new RuntimeException(error);
        }
        String langKey = name = Strings.isNullOrEmpty(annotation.name()) ? annotation.modid() : annotation.name();
        Config.LangKey langKeyAnnotation = configClass.getAnnotation(Config.LangKey.class);
        if (langKeyAnnotation != null) {
            langKey = langKeyAnnotation.value();
        }
        if (annotation.category().isEmpty()) {
            ArrayList<IConfigElement> elements = Lists.newArrayList();
            Set<String> catNames = config.getCategoryNames();
            for (String catName : catNames) {
                ConfigCategory category;
                if (catName.isEmpty() || (category = config.getCategory(catName)).isChild()) continue;
                DummyConfigElement.DummyCategoryElement element = new DummyConfigElement.DummyCategoryElement(category.getName(), category.getLanguagekey(), new ConfigElement(category).getChildElements());
                element.setRequiresMcRestart(category.requiresMcRestart());
                element.setRequiresWorldRestart(category.requiresWorldRestart());
                elements.add(element);
            }
            return new DummyConfigElement.DummyCategoryElement(name, langKey, elements);
        }
        ConfigCategory category = config.getCategory(annotation.category());
        DummyConfigElement.DummyCategoryElement element = new DummyConfigElement.DummyCategoryElement(name, langKey, new ConfigElement(category).getChildElements());
        element.setRequiresMcRestart(category.requiresMcRestart());
        element.setRequiresWorldRestart(category.requiresWorldRestart());
        return element;
    }
}

