/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Range;
import net.minecraftforge.common.property.IUnlistedProperty;

public class PropertyFloat
implements IUnlistedProperty<Float> {
    private final String name;
    private final Predicate<Float> validator;

    public PropertyFloat(String name) {
        this(name, Predicates.alwaysTrue());
    }

    public PropertyFloat(String name, float min, float max) {
        this(name, Range.closed(Float.valueOf(min), Float.valueOf(max)));
    }

    public PropertyFloat(String name, Predicate<Float> validator) {
        this.name = name;
        this.validator = validator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid(Float value) {
        return this.validator.apply(value);
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public String valueToString(Float value) {
        return value.toString();
    }
}

