/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.World;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class<?>[][] commonTypes = new Class[][]{{akc.class}, {agv.a.class, String.class, Integer.TYPE, int[].class, Integer.TYPE, qe.class, Float.TYPE}, {acd.a.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {vu.class}, {vr.class, Class.class, Integer.TYPE, bcz.class, Boolean.TYPE, Boolean.TYPE}, {bbt.p.a.class}, {all.class, Predicate.class}, {asw.a.class}, {bhc.a.class}, {ana.class, Integer.TYPE}, {aed.a.class}, {ain.a.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {aje.class, a.class, String.class}, {aar.class, String.class, Integer.TYPE}, {vq.a.class, BiPredicate.class}};

    @Nullable
    public static akc addAction(String name) {
        return EnumHelper.addEnum(akc.class, name, new Object[0]);
    }

    @Nullable
    public static agv.a addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, qe soundOnEquip, float toughness) {
        return EnumHelper.addEnum(agv.a.class, name, textureName, durability, reductionAmounts, enchantability, soundOnEquip, Float.valueOf(toughness));
    }

    @Nullable
    public static acd.a addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(acd.a.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    @Nullable
    public static vu addCreatureAttribute(String name) {
        return EnumHelper.addEnum(vu.class, name, new Object[0]);
    }

    @Nullable
    public static vr addCreatureType(String name, Class<? extends vf> typeClass, int maxNumber, bcz material, boolean peaceful, boolean animal) {
        return EnumHelper.addEnum(vr.class, name, typeClass, maxNumber, material, peaceful, animal);
    }

    @Nullable
    public static bbt.p.a addDoor(String name) {
        return EnumHelper.addEnum(bbt.p.a.class, name, new Object[0]);
    }

    @Nullable
    public static all addEnchantmentType(String name, Predicate<ain> delegate) {
        return EnumHelper.addEnum(all.class, name, delegate);
    }

    @Nullable
    public static asw.a addSensitivity(String name) {
        return EnumHelper.addEnum(asw.a.class, name, new Object[0]);
    }

    @Nullable
    public static bhc.a addMovingObjectType(String name) {
        return EnumHelper.addEnum(bhc.a.class, name, new Object[0]);
    }

    @Nullable
    public static ana addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(ana.class, name, lightValue);
    }

    @Nullable
    public static aed.a addStatus(String name) {
        return EnumHelper.addEnum(aed.a.class, name, new Object[0]);
    }

    @Nullable
    public static ain.a addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHelper.addEnum(ain.a.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability);
    }

    @Nullable
    @Deprecated
    public static aje addRarity(String name, a color, String displayName) {
        return EnumHelper.addEnum(aje.class, name, new Object[]{color, displayName});
    }

    @Nullable
    public static vq.a addSpawnPlacementType(String name, BiPredicate<amy, et> predicate) {
        return EnumHelper.addEnum(vq.a.class, name, predicate);
    }

    @Nullable
    public static aar addHorseArmor(String name, String textureLocation, int armorStrength) {
        return EnumHelper.addEnum(aar.class, name, textureLocation, armorStrength);
    }

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e2) {
            FMLLog.log.error("Error setting up EnumHelper.", (Throwable)e2);
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, @Nullable String value, int ordinal, Class<?>[] additionalTypes, @Nullable Object[] additionalValues) throws Exception {
        int additionalParamsCount = additionalValues == null ? 0 : additionalValues.length;
        Object[] params = new Object[additionalParamsCount + 2];
        params[0] = value;
        params[1] = ordinal;
        if (additionalValues != null) {
            System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{params})));
    }

    public static void setFailsafeFieldValue(Field field, @Nullable Object target, @Nullable Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
        EnumHelper.blankField(enumClass, "enumVars");
    }

    @Nullable
    private static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        EnumHelper.setup();
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    @Nullable
    protected static <T extends Enum<?>> T addEnum(Class<?>[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class<?>[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static void testEnum(Class<? extends Enum<?>> enumType, Class<?>[] paramTypes) {
        EnumHelper.addEnum(true, enumType, null, paramTypes, null);
    }

    @Nullable
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return EnumHelper.addEnum(false, enumType, enumName, paramTypes, paramValues);
    }

    @Nullable
    private static <T extends Enum<?>> T addEnum(boolean test, final Class<T> enumType, @Nullable String enumName, final Class<?>[] paramTypes, @Nullable Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            final ArrayList<String> lines = Lists.newArrayList();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            for (String line : lines) {
                FMLLog.log.fatal(line);
            }
            if (test) {
                throw new EnhancedRuntimeException("Could not find $VALUES field for enum: " + enumType.getName()){

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        for (String line : lines) {
                            stream.println(line);
                        }
                    }
                };
            }
            return null;
        }
        if (test) {
            Object ctr = null;
            Exception ex = null;
            try {
                ctr = EnumHelper.getConstructorAccessor(enumType, paramTypes);
            }
            catch (Exception e2) {
                ex = e2;
            }
            if (ctr == null || ex != null) {
                throw new EnhancedRuntimeException(String.format("Could not find constructor for Enum %s", enumType.getName()), (Throwable)ex){

                    private String toString(Class<?>[] cls) {
                        StringBuilder b2 = new StringBuilder();
                        for (int x = 0; x < cls.length; ++x) {
                            b2.append(cls[x].getName());
                            if (x == cls.length - 1) continue;
                            b2.append(", ");
                        }
                        return b2.toString();
                    }

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Target Arguments:");
                        stream.println("    java.lang.String, int, " + this.toString(paramTypes));
                        stream.println("Found Constructors:");
                        for (Constructor<?> ctr : enumType.getDeclaredConstructors()) {
                            stream.println("    " + this.toString(ctr.getParameterTypes()));
                        }
                    }
                };
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            T newValue = EnumHelper.makeEnum(enumType, enumName, previousValues.length, paramTypes, paramValues);
            EnumHelper.setFailsafeFieldValue(valuesField, null, ArrayUtils.add(previousValues, newValue));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e3) {
            FMLLog.log.error("Error adding enum with EnumHelper.", (Throwable)e3);
            throw new RuntimeException(e3);
        }
    }

    public static World.Environment addBukkitEnvironment(int id, String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

