/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JsonUtils {
    private static <E> TypeToken<List<E>> listOf(Type arg) {
        return new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of(arg));
    }

    @Nullable
    public static fy readNBT(JsonObject json, String key) {
        if (rc.g(json, key)) {
            try {
                return gp.a(rc.h(json, key));
            }
            catch (go e2) {
                throw new JsonSyntaxException("Malformed NBT tag", e2);
            }
        }
        return null;
    }

    private static <E> TypeToken<Map<String, E>> mapOf(Type arg) {
        return new TypeToken<Map<String, E>>(){}.where(new TypeParameter<E>(){}, TypeToken.of(arg));
    }

    public static enum ImmutableMapTypeAdapter implements JsonDeserializer<ImmutableMap<String, ?>>,
    JsonSerializer<ImmutableMap<String, ?>>
    {
        INSTANCE;


        @Override
        public ImmutableMap<String, ?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = JsonUtils.mapOf(typeArguments[1]).getType();
            Map map = (Map)context.deserialize(json, parameterizedType);
            return ImmutableMap.copyOf(map);
        }

        @Override
        public JsonElement serialize(ImmutableMap<String, ?> src, Type type, JsonSerializationContext context) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = JsonUtils.mapOf(typeArguments[1]).getType();
            return context.serialize(src, parameterizedType);
        }
    }

    public static enum ImmutableListTypeAdapter implements JsonDeserializer<ImmutableList<?>>,
    JsonSerializer<ImmutableList<?>>
    {
        INSTANCE;


        @Override
        public ImmutableList<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parametrizedType = JsonUtils.listOf(typeArguments[0]).getType();
            List list = (List)context.deserialize(json, parametrizedType);
            return ImmutableList.copyOf(list);
        }

        @Override
        public JsonElement serialize(ImmutableList<?> src, Type type, JsonSerializationContext context) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parametrizedType = JsonUtils.listOf(typeArguments[0]).getType();
            return context.serialize(src, parametrizedType);
        }
    }
}

