/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;
import net.minecraftforge.fml.common.eventhandler.IContextSetter;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class RegistryEvent<T extends IForgeRegistryEntry<T>>
extends GenericEvent<T>
implements IContextSetter {
    RegistryEvent(Class<T> clazz) {
        super(clazz);
    }

    public static class MissingMappings<T extends IForgeRegistryEntry<T>>
    extends RegistryEvent<T> {
        private final IForgeRegistry<T> registry;
        private final nf name;
        private final ImmutableList<Mapping<T>> mappings;
        private ModContainer activeMod;

        public MissingMappings(nf name, IForgeRegistry<T> registry, Collection<Mapping<T>> missed) {
            super(registry.getRegistrySuperType());
            this.registry = registry;
            this.name = name;
            this.mappings = ImmutableList.copyOf(missed);
        }

        @Override
        public void setModContainer(ModContainer mod) {
            this.activeMod = mod;
        }

        public nf getName() {
            return this.name;
        }

        public IForgeRegistry<T> getRegistry() {
            return this.registry;
        }

        public ImmutableList<Mapping<T>> getMappings() {
            return ImmutableList.copyOf(this.mappings.stream().filter(e2 -> e2.key.b().equals(this.activeMod.getModId())).collect(Collectors.toList()));
        }

        public ImmutableList<Mapping<T>> getAllMappings() {
            return this.mappings;
        }

        public static class Mapping<T extends IForgeRegistryEntry<T>> {
            public final IForgeRegistry<T> registry;
            private final IForgeRegistry<T> pool;
            public final nf key;
            public final int id;
            private Action action = Action.DEFAULT;
            private T target;

            public Mapping(IForgeRegistry<T> registry, IForgeRegistry<T> pool, nf key, int id) {
                this.registry = registry;
                this.pool = pool;
                this.key = key;
                this.id = id;
            }

            public void ignore() {
                this.action = Action.IGNORE;
            }

            public void warn() {
                this.action = Action.WARN;
            }

            public void fail() {
                this.action = Action.FAIL;
            }

            public void remap(T target) {
                Validate.notNull(target, "Remap target can not be null", new Object[0]);
                Validate.isTrue(this.pool.getKey(target) != null, String.format("The specified entry %s hasn't been registered in registry yet.", target), new Object[0]);
                this.action = Action.REMAP;
                this.target = target;
            }

            public Action getAction() {
                return this.action;
            }

            public T getTarget() {
                return this.target;
            }
        }

        public static enum Action {
            DEFAULT,
            IGNORE,
            WARN,
            FAIL,
            REMAP;

        }
    }

    public static class Register<T extends IForgeRegistryEntry<T>>
    extends RegistryEvent<T> {
        private final IForgeRegistry<T> registry;
        private final nf name;

        public Register(nf name, IForgeRegistry<T> registry) {
            super(registry.getRegistrySuperType());
            this.name = name;
            this.registry = registry;
        }

        public IForgeRegistry<T> getRegistry() {
            return this.registry;
        }

        public nf getName() {
            return this.name;
        }
    }

    public static class NewRegistry
    extends Event {
    }
}

