/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;

public class PlayerEvent
extends LivingEvent {
    private final aed entityPlayer;

    public PlayerEvent(aed player) {
        super(player);
        this.entityPlayer = player;
    }

    public aed getEntityPlayer() {
        return this.entityPlayer;
    }

    public static class Visibility
    extends PlayerEvent {
        private double visibilityModifier = 1.0;

        public Visibility(aed player) {
            super(player);
        }

        public void modifyVisibility(double mod) {
            this.visibilityModifier *= mod;
        }

        public double getVisibilityModifier() {
            return this.visibilityModifier;
        }
    }

    public static class SaveToFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(aed player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(aed player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        private final vg target;

        public StopTracking(aed player, vg target) {
            super(player);
            this.target = target;
        }

        public vg getTarget() {
            return this.target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        private final vg target;

        public StartTracking(aed player, vg target) {
            super(player);
            this.target = target;
        }

        public vg getTarget() {
            return this.target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        private final aed original;
        private final boolean wasDeath;

        public Clone(aed _new, aed oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public aed getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        private final String username;
        private String displayname;

        public NameFormat(aed player, String username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
            CraftPlayer cplayer = (CraftPlayer)player.getBukkitEntity();
            String displayName = cplayer.getDisplayName();
            if (displayName != null) {
                this.displayname = displayName;
            }
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(String displayname) {
            this.displayname = displayname;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        private final awt state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final et pos;

        public BreakSpeed(aed player, awt state, float original, et pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = pos;
        }

        public awt getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public et getPos() {
            return this.pos;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        private final awt state;
        private boolean success;

        public HarvestCheck(aed player, awt state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public awt getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

