/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_12_R1.event.CraftEventFactory;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final amu world;
    private final et pos;
    private final awt state;

    public BlockEvent(amu world, et pos, awt state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public amu getWorld() {
        return this.world;
    }

    public et getPos() {
        return this.pos;
    }

    public awt getState() {
        return this.state;
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final ass.a size;

        public PortalSpawnEvent(amu world, et pos, awt state, ass.a size) {
            super(world, pos, state);
            this.size = size;
        }

        public ass.a getPortalSize() {
            return this.size;
        }
    }

    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEvent {
        private final vg entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(amu world, et pos, awt state, float fallDistance, vg entity) {
            super(world, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public vg getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(amu world, et pos, awt state) {
            super(world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final awt originalState;

            public Post(amu world, et pos, awt original, awt state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public awt getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(amu world, et pos, awt state) {
                super(world, pos, state);
            }
        }
    }

    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEvent {
        private final et liquidPos;
        private awt newState;
        private awt origState;

        public FluidPlaceBlockEvent(amu world, et pos, et liquidPos, awt state) {
            super(world, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = world.o(pos);
        }

        public et getLiquidPos() {
            return this.liquidPos;
        }

        public awt getNewState() {
            return this.newState;
        }

        public void setNewState(awt state) {
            this.newState = state;
        }

        public awt getOriginalState() {
            return this.origState;
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(amu world, et pos, awt state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<fa> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(amu world, et pos, awt state, EnumSet<fa> notifiedSides, boolean forceRedstoneUpdate) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<fa> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull awt placedAgainst, @Nonnull aed player, @Nonnull ub hand) {
            super(blockSnapshots.get(0), placedAgainst, player, hand);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            ArrayList blockStates = this.blockSnapshots.stream().map(CraftBlockState::new).collect(Collectors.toCollection(() -> new ArrayList(blockSnapshots.size())));
            BlockMultiPlaceEvent event = CraftEventFactory.callBlockMultiPlaceEvent(this.getWorld(), player, hand, blockStates, this.getPos().p(), this.getPos().q(), this.getPos().r());
            this.setCanceled(event.isCancelled() || !event.canBuild());
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, player.b(hand), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class EntityMultiPlaceEvent
    extends EntityPlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull awt placedAgainst, @Nullable vg entity) {
            super(blockSnapshots.get(0), placedAgainst, entity);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created EntityMultiPlaceEvent - [PlacedAgainst: %s ][Entity: %s ]\n", placedAgainst, entity);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    @Deprecated
    public static class PlaceEvent
    extends EntityPlaceEvent {
        private final aed player;
        private final ub hand;

        public PlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull awt placedAgainst, @Nonnull aed player, @Nonnull ub hand) {
            super(blockSnapshot, placedAgainst, player);
            this.player = player;
            this.hand = hand;
            if (!(this instanceof MultiPlaceEvent)) {
                CraftBlockState blockstate = new CraftBlockState(blockSnapshot);
                BlockPlaceEvent bukkitEvent = CraftEventFactory.callBlockPlaceEvent(this.getWorld(), player, hand, blockstate, this.getPos().p(), this.getPos().q(), this.getPos().r());
                if (bukkitEvent.isCancelled() || !bukkitEvent.canBuild()) {
                    this.setCanceled(true);
                }
            }
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ][Hand: %s]\n", new Object[]{this.getPlacedBlock(), placedAgainst, player.b(hand), player, hand});
            }
        }

        public aed getPlayer() {
            return this.player;
        }

        @Nonnull
        @Deprecated
        public aip getItemInHand() {
            return this.player.b(this.hand);
        }

        public ub getHand() {
            return this.hand;
        }
    }

    @Cancelable
    public static class EntityPlaceEvent
    extends BlockEvent {
        private final vg entity;
        private final BlockSnapshot blockSnapshot;
        private final awt placedBlock;
        private final awt placedAgainst;

        public EntityPlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull awt placedAgainst, @Nullable vg entity) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), !(entity instanceof aed) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock());
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof aed) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created EntityPlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][Entity: %s ]\n", this.getPlacedBlock(), placedAgainst, entity);
            }
        }

        @Nullable
        public vg getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public awt getPlacedBlock() {
            return this.placedBlock;
        }

        public awt getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final aed player;
        private int exp;

        public BreakEvent(amu world, et pos, awt state, aed player) {
            super(world, pos, state);
            this.player = player;
            BlockBreakEvent bukkitEvent = CraftEventFactory.callBlockBreakEvent(world, pos, state, (oq)player);
            if (bukkitEvent.isCancelled()) {
                this.setCanceled(true);
            } else {
                this.exp = bukkitEvent.getExpToDrop();
            }
        }

        public aed getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<aip> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final aed harvester;

        public HarvestDropsEvent(amu world, et pos, awt state, int fortuneLevel, float dropChance, List<aip> drops, aed harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<aip> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public aed getHarvester() {
            return this.harvester;
        }
    }
}

