/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends aow
implements IFluidBlock {
    protected static final Map<aow, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<aow, Boolean> displacements = Maps.newHashMap();
    public static final axi LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final UnlistedPropertyBool[] SIDE_OVERLAYS;
    public static final ImmutableList<IUnlistedProperty<?>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected float quantaFraction = 0.8888889f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected amm renderLayer = amm.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, bcz material, bda mapColor) {
        super(material, mapColor);
        this.a(true);
        this.p();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.w(this.A.b().a(LEVEL, this.getMaxRenderHeightMeta()));
    }

    public BlockFluidBase(Fluid fluid, bcz material) {
        this(fluid, material, material.r());
    }

    @Override
    @Nonnull
    protected awu b() {
        return new awu.Builder(this).add(LEVEL).add(FLUID_RENDER_PROPS.toArray(new IUnlistedProperty[0])).build();
    }

    @Override
    public int e(@Nonnull awt state) {
        return state.c(LEVEL);
    }

    @Override
    @Deprecated
    @Nonnull
    public awt a(int meta) {
        return this.t().a(LEVEL, meta);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        this.quantaFraction = (float)quantaPerBlock / ((float)quantaPerBlock + 1.0f);
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(amm renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public boolean canDisplace(amy world, et pos) {
        awt state = world.o(pos);
        aow block = state.u();
        if (block.isAir(state, world, pos)) {
            return true;
        }
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return this.displacements.get(block);
        }
        bcz material = state.a();
        if (material.c() || material == bcz.E || material == bcz.J) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(amu world, et pos) {
        awt state;
        aow block;
        boolean canDisplace = this.canDisplace(world, pos);
        if (canDisplace && !(block = (state = world.o(pos)).u()).isAir(state, world, pos) && !BlockFluidBase.isFluid(state) && block != aox.aH) {
            block.b(world, pos, state, 0);
        }
        return canDisplace;
    }

    public abstract int getQuantaValue(amy var1, et var2);

    @Override
    public abstract boolean a(@Nonnull awt var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    @Override
    public void c(@Nonnull amu world, @Nonnull et pos, @Nonnull awt state) {
        world.a(pos, (aow)this, this.tickRate);
    }

    @Override
    public void a(@Nonnull awt state, @Nonnull amu world, @Nonnull et pos, @Nonnull aow neighborBlock, @Nonnull et neighbourPos) {
        world.a(pos, (aow)this, this.tickRate);
    }

    @Override
    public boolean r() {
        return false;
    }

    @Override
    public boolean b(@Nonnull amy world, @Nonnull et pos) {
        return true;
    }

    @Override
    @Nonnull
    public ain a(@Nonnull awt state, @Nonnull Random rand, int fortune) {
        return air.a;
    }

    @Override
    public int a(@Nonnull Random par1Random) {
        return 0;
    }

    @Override
    public int a(@Nonnull amu world) {
        return this.tickRate;
    }

    @Override
    @Nonnull
    public bhe a(@Nonnull amu world, @Nonnull et pos, @Nonnull vg entity, @Nonnull bhe vec) {
        return this.densityDir > 0 ? vec : vec.e(this.getFlowVector(world, pos));
    }

    public int getLightValue(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        return (int)(this.getQuantaPercentage(world, pos) * (float)this.maxScaledLight);
    }

    @Override
    public boolean b(@Nonnull awt state) {
        return false;
    }

    @Override
    public boolean c(@Nonnull awt state) {
        return false;
    }

    public int e(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.c(this.densityDir), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public amm f() {
        return this.renderLayer;
    }

    @Override
    @Nonnull
    public awr a(@Nonnull amy worldIn, @Nonnull awt state, @Nonnull et pos, @Nonnull fa face) {
        return awr.i;
    }

    public boolean a(@Nonnull awt state, @Nonnull amy world, @Nonnull et pos, @Nonnull fa side) {
        awt neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (side == (this.densityDir < 0 ? fa.b : fa.a)) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    private static boolean isFluid(@Nonnull awt blockstate) {
        return blockstate.a().d() || blockstate.u() instanceof IFluidBlock;
    }

    @Nonnull
    public awt getExtendedState(@Nonnull awt oldState, @Nonnull amy world, @Nonnull et pos) {
        int j2;
        int i2;
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(world, pos)));
        awt[][] upBlockState = new awt[3][3];
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        upBlockState[1][1] = world.o(pos.c(this.densityDir));
        height[1][1] = this.getFluidHeightForRender(world, pos, upBlockState[1][1]);
        if (height[1][1] == 1.0f) {
            for (i2 = 0; i2 < 2; ++i2) {
                for (j2 = 0; j2 < 2; ++j2) {
                    corner[i2][j2] = 1.0f;
                }
            }
        } else {
            for (i2 = 0; i2 < 3; ++i2) {
                for (j2 = 0; j2 < 3; ++j2) {
                    if (i2 == 1 && j2 == 1) continue;
                    upBlockState[i2][j2] = world.o(pos.a(i2 - 1, 0, j2 - 1).c(this.densityDir));
                    height[i2][j2] = this.getFluidHeightForRender(world, pos.a(i2 - 1, 0, j2 - 1), upBlockState[i2][j2]);
                }
            }
            for (i2 = 0; i2 < 2; ++i2) {
                for (j2 = 0; j2 < 2; ++j2) {
                    corner[i2][j2] = this.getFluidHeightAverage(height[i2][j2], height[i2][j2 + 1], height[i2 + 1][j2], height[i2 + 1][j2 + 1]);
                }
            }
            boolean n2 = BlockFluidBase.isFluid(upBlockState[0][1]);
            boolean s = BlockFluidBase.isFluid(upBlockState[2][1]);
            boolean w = BlockFluidBase.isFluid(upBlockState[1][0]);
            boolean e2 = BlockFluidBase.isFluid(upBlockState[1][2]);
            boolean nw = BlockFluidBase.isFluid(upBlockState[0][0]);
            boolean ne2 = BlockFluidBase.isFluid(upBlockState[0][2]);
            boolean sw = BlockFluidBase.isFluid(upBlockState[2][0]);
            boolean se = BlockFluidBase.isFluid(upBlockState[2][2]);
            if (nw || n2 || w) {
                corner[0][0] = 1.0f;
            }
            if (ne2 || n2 || e2) {
                corner[0][1] = 1.0f;
            }
            if (sw || s || w) {
                corner[1][0] = 1.0f;
            }
            if (se || s || e2) {
                corner[1][1] = 1.0f;
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            fa side = fa.b(i2);
            et offset = pos.a(side);
            boolean useOverlay = world.o(offset).d(world, offset, side.d()) == awr.a;
            state = state.withProperty(SIDE_OVERLAYS[i2], useOverlay);
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static int getDensity(amy world, et pos) {
        awt state = world.o(pos);
        aow block = state.u();
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getDensity();
        }
        Fluid fluid = BlockFluidBase.getFluid(state);
        if (fluid != null) {
            return fluid.getDensity();
        }
        return Integer.MAX_VALUE;
    }

    public static int getTemperature(amy world, et pos) {
        awt state = world.o(pos);
        aow block = state.u();
        if (block instanceof BlockFluidBase) {
            return ((BlockFluidBase)block).getTemperature();
        }
        Fluid fluid = BlockFluidBase.getFluid(state);
        if (fluid != null) {
            return fluid.getTemperature();
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    private static Fluid getFluid(awt state) {
        aow block = state.u();
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)((Object)block)).getFluid();
        }
        if (block instanceof aru) {
            if (state.a() == bcz.h) {
                return FluidRegistry.WATER;
            }
            if (state.a() == bcz.i) {
                return FluidRegistry.LAVA;
            }
        }
        return null;
    }

    public static double getFlowDirection(amy world, et pos) {
        awt state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bhe vec = ((BlockFluidBase)state.u()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : rk.c(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(amy world, et pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(amy world, et pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(amy world, et pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        for (int i2 = 0; i2 < flow.length; ++i2) {
            if (flow[i2] >= this.quantaFraction) {
                total += flow[i2] * 10.0f;
                count += 10;
            }
            if (!(flow[i2] >= 0.0f)) continue;
            total += flow[i2];
            ++count;
        }
        return total / (float)count;
    }

    public float getFluidHeightForRender(amy world, et pos, @Nonnull awt up2) {
        awt here = world.o(pos);
        if (here.u() == this) {
            if (BlockFluidBase.isFluid(up2)) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return this.quantaFraction;
            }
        }
        if (here.u() instanceof aru) {
            return Math.min(1.0f - aru.b(here.c(aru.b)), this.quantaFraction);
        }
        return !here.a().a() && up2.u() == this ? 1.0f : this.getQuantaPercentage(world, pos) * this.quantaFraction;
    }

    public bhe getFlowVector(amy world, et pos) {
        et offset;
        bhe vec = new bhe(0.0, 0.0, 0.0);
        int decay = this.getFlowDecay(world, pos);
        for (fa side : fa.c.a) {
            int power;
            offset = pos.a(side);
            int otherDecay = this.getFlowDecay(world, offset);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(offset).a().c() || (otherDecay = this.getFlowDecay(world, offset.b(this.densityDir))) >= this.quantaPerBlock) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b(side.g() * power, 0.0, side.i() * power);
                continue;
            }
            power = otherDecay - decay;
            vec = vec.b(side.g() * power, 0.0, side.i() * power);
        }
        if (this.hasVerticalFlow(world, pos)) {
            for (fa side : fa.c.a) {
                offset = pos.a(side);
                if (!this.causesDownwardCurrent(world, offset, side) && !this.causesDownwardCurrent(world, offset.c(this.densityDir), side)) continue;
                vec = vec.a().b(0.0, 6.0 * (double)this.densityDir, 0.0);
                break;
            }
        }
        return vec.a();
    }

    private int getFlowDecay(amy world, et pos) {
        return this.quantaPerBlock - this.getEffectiveQuanta(world, pos);
    }

    final int getEffectiveQuanta(amy world, et pos) {
        int quantaValue = this.getQuantaValue(world, pos);
        return quantaValue > 0 && quantaValue < this.quantaPerBlock && this.hasVerticalFlow(world, pos) ? this.quantaPerBlock : quantaValue;
    }

    final boolean hasVerticalFlow(amy world, et pos) {
        return world.o(pos.c(this.densityDir)).u() == this;
    }

    protected boolean causesDownwardCurrent(amy world, et pos, fa face) {
        awt state = world.o(pos);
        aow block = state.u();
        if (block == this) {
            return false;
        }
        if (face == (this.densityDir < 0 ? fa.b : fa.a)) {
            return true;
        }
        if (state.a() == bcz.w) {
            return false;
        }
        boolean flag = BlockFluidBase.c(block) || block instanceof aud;
        return !flag && state.d(world, pos, face) == awr.a;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(amu world, et pos) {
        return this.getFilledPercentage((amy)world, pos);
    }

    public float getFilledPercentage(amy world, et pos) {
        int quantaRemaining = this.getEffectiveQuanta(world, pos);
        float remaining = ((float)quantaRemaining + 1.0f) / (this.quantaPerBlockFloat + 1.0f);
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    @Override
    public bhb a(@Nonnull awt blockState, @Nonnull amy worldIn, @Nonnull et pos) {
        return k;
    }

    @SideOnly(value=Side.CLIENT)
    public bhe getFogColor(amu world, et pos, awt state, vg entity, bhe originalColor, float partialTicks) {
        if (!this.isWithinFluid(world, pos, bhv.a((vg)entity, (double)partialTicks))) {
            et otherPos = pos.c(this.densityDir);
            awt otherState = world.o(otherPos);
            return otherState.u().getFogColor(world, otherPos, otherState, entity, originalColor, partialTicks);
        }
        if (this.getFluid() != null) {
            int color = this.getFluid().getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            return new bhe(red, green, blue);
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    public awt getStateAtViewpoint(awt state, amy world, et pos, bhe viewpoint) {
        if (!this.isWithinFluid(world, pos, viewpoint)) {
            return world.o(pos.c(this.densityDir));
        }
        return super.getStateAtViewpoint(state, world, pos, viewpoint);
    }

    private boolean isWithinFluid(amy world, et pos, bhe vec) {
        float filled = this.getFilledPercentage(world, pos);
        return filled < 0.0f ? vec.c > (double)((float)pos.q() + filled + 1.0f) : vec.c < (double)((float)pos.q() + filled);
    }

    public float getBlockLiquidHeight(amu world, et pos, awt state, bcz material) {
        float filled = this.getFilledPercentage(world, pos);
        return Math.max(filled, 0.0f);
    }

    static {
        defaultDisplacements.put(aox.ao, false);
        defaultDisplacements.put(aox.ap, false);
        defaultDisplacements.put(aox.aq, false);
        defaultDisplacements.put(aox.ar, false);
        defaultDisplacements.put(aox.as, false);
        defaultDisplacements.put(aox.at, false);
        defaultDisplacements.put(aox.bd, false);
        defaultDisplacements.put(aox.cw, false);
        defaultDisplacements.put(aox.aO, false);
        defaultDisplacements.put(aox.aP, false);
        defaultDisplacements.put(aox.aQ, false);
        defaultDisplacements.put(aox.aR, false);
        defaultDisplacements.put(aox.aS, false);
        defaultDisplacements.put(aox.aT, false);
        defaultDisplacements.put(aox.bz, false);
        defaultDisplacements.put(aox.bo, false);
        defaultDisplacements.put(aox.bp, false);
        defaultDisplacements.put(aox.bq, false);
        defaultDisplacements.put(aox.br, false);
        defaultDisplacements.put(aox.bs, false);
        defaultDisplacements.put(aox.bt, false);
        defaultDisplacements.put(aox.aB, false);
        defaultDisplacements.put(aox.az, false);
        defaultDisplacements.put(aox.ch, false);
        defaultDisplacements.put(aox.ci, false);
        defaultDisplacements.put(aox.au, false);
        defaultDisplacements.put(aox.bi, false);
        defaultDisplacements.put(aox.bj, false);
        defaultDisplacements.put(aox.cH, false);
        defaultDisplacements.put(aox.aY, false);
        defaultDisplacements.put(aox.bF, false);
        defaultDisplacements.put(aox.bZ, false);
        defaultDisplacements.put(aox.cv, false);
        defaultDisplacements.put(aox.cK, false);
        defaultDisplacements.put(aox.cL, false);
        defaultDisplacements.put(aox.ba, false);
        defaultDisplacements.put(aox.aA, false);
        defaultDisplacements.put(aox.an, false);
        defaultDisplacements.put(aox.ax, false);
        defaultDisplacements.put(aox.aM, false);
        LEVEL = axi.a("level", 0, 15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction", -1000.0f, 1000.0f);
        SIDE_OVERLAYS = new UnlistedPropertyBool[4];
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(FLOW_DIRECTION);
        for (int i2 = 0; i2 < 4; ++i2) {
            BlockFluidBase.LEVEL_CORNERS[i2] = new PropertyFloat("level_corner_" + i2, 0.0f, 1.0f);
            builder.add(LEVEL_CORNERS[i2]);
            BlockFluidBase.SIDE_OVERLAYS[i2] = new UnlistedPropertyBool("side_overlay_" + i2);
            builder.add(SIDE_OVERLAYS[i2]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }

    private static final class UnlistedPropertyBool
    extends Properties.PropertyAdapter<Boolean> {
        public UnlistedPropertyBool(String name) {
            super(axf.a(name));
        }
    }
}

