/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;

public class GuiConfig
extends blk {
    public final blk parentScreen;
    public String title = "Config GUI";
    @Nullable
    public String titleLine2;
    public final List<IConfigElement> configElements;
    public final List<GuiConfigEntries.IConfigEntry> initEntries;
    public GuiConfigEntries entryList;
    protected GuiButtonExt btnDefaultAll;
    protected GuiButtonExt btnUndoAll;
    protected GuiCheckBox chkApplyGlobally;
    public final String modID;
    @Nullable
    public final String configID;
    public final boolean isWorldRunning;
    public final boolean allRequireWorldRestart;
    public final boolean allRequireMcRestart;
    public boolean needsRefresh = true;
    protected HoverChecker undoHoverChecker;
    protected HoverChecker resetHoverChecker;
    protected HoverChecker checkBoxHoverChecker;

    public GuiConfig(blk parentScreen, String modid, String title) {
        this(parentScreen, modid, false, false, title, ConfigManager.getModConfigClasses(modid));
    }

    public GuiConfig(blk parentScreen, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, Class<?> ... configClasses) {
        this(parentScreen, GuiConfig.collectConfigElements(configClasses), modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    private static List<IConfigElement> collectConfigElements(Class<?>[] configClasses) {
        List<Object> toReturn;
        if (configClasses.length == 1) {
            toReturn = ConfigElement.from(configClasses[0]).getChildElements();
        } else {
            toReturn = new ArrayList();
            for (Class<?> clazz : configClasses) {
                toReturn.add(ConfigElement.from(clazz));
            }
        }
        toReturn.sort(Comparator.comparing(e2 -> cey.a((String)e2.getLanguageKey(), (Object[])new Object[0])));
        return toReturn;
    }

    public GuiConfig(blk parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, configID, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(blk parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(blk parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
    }

    public GuiConfig(blk parentScreen, List<IConfigElement> configElements, String modID, @Nullable String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, @Nullable String titleLine2) {
        IConfigElement element;
        Iterator<IConfigElement> iterator;
        this.j = bib.z();
        this.parentScreen = parentScreen;
        this.configElements = configElements;
        this.entryList = new GuiConfigEntries(this, this.j);
        this.initEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
        this.allRequireWorldRestart = allRequireWorldRestart;
        if (!allRequireWorldRestart) {
            iterator = configElements.iterator();
            if (iterator.hasNext()) {
                element = iterator.next();
                if (!element.requiresWorldRestart()) {
                    // empty if block
                }
            } else {
                allRequireWorldRestart = true;
            }
        }
        this.allRequireMcRestart = allRequireMcRestart;
        if (!allRequireMcRestart) {
            iterator = configElements.iterator();
            if (iterator.hasNext()) {
                element = iterator.next();
                if (!element.requiresMcRestart()) {
                    // empty if block
                }
            } else {
                allRequireMcRestart = true;
            }
        }
        this.modID = modID;
        this.configID = configID;
        boolean bl2 = this.isWorldRunning = this.j.f != null;
        if (title != null) {
            this.title = title;
        }
        this.titleLine2 = titleLine2;
        if (this.titleLine2 != null && this.titleLine2.startsWith(" > ")) {
            this.titleLine2 = this.titleLine2.replaceFirst(" > ", "");
        }
    }

    public static String getAbridgedConfigPath(String path) {
        bib mc = bib.z();
        if (mc.w.getAbsolutePath().endsWith(".")) {
            return path.replace("\\", "/").replace(mc.w.getAbsolutePath().replace("\\", "/").substring(0, mc.w.getAbsolutePath().length() - 1), "/.minecraft/");
        }
        return path.replace("\\", "/").replace(mc.w.getAbsolutePath().replace("\\", "/"), "/.minecraft");
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.j);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.j.k.a("\u21b6") * 2;
        int resetGlyphWidth = this.j.k.a("\u2604") * 2;
        int doneWidth = Math.max(this.j.k.a(cey.a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.j.k.a(" " + cey.a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.j.k.a(" " + cey.a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int checkWidth = this.j.k.a(cey.a((String)"fml.configgui.applyGlobally", (Object[])new Object[0])) + 13;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5 + checkWidth) / 2;
        this.n.add(new GuiButtonExt(2000, this.l / 2 - buttonWidthHalf, this.m - 29, doneWidth, 20, cey.a((String)"gui.done", (Object[])new Object[0])));
        this.btnDefaultAll = new GuiUnicodeGlyphButton(2001, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.m - 29, resetWidth, 20, " " + cey.a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.n.add(this.btnDefaultAll);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.l / 2 - buttonWidthHalf + doneWidth + 5, this.m - 29, undoWidth, 20, " " + cey.a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.n.add(this.btnUndoAll);
        this.chkApplyGlobally = new GuiCheckBox(2003, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5 + resetWidth + 5, this.m - 24, cey.a((String)"fml.configgui.applyGlobally", (Object[])new Object[0]), false);
        this.n.add(this.chkApplyGlobally);
        this.undoHoverChecker = new HoverChecker(this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker(this.btnDefaultAll, 800);
        this.checkBoxHoverChecker = new HoverChecker(this.chkApplyGlobally, 800);
        this.entryList.initGui();
    }

    public void m() {
        this.entryList.onGuiClosed();
        if (this.configID != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.b();
        }
        if (!(this.parentScreen instanceof GuiConfig)) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    protected void a(bja button) {
        if (button.k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded(this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post(event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post(new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.j.a((blk)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", new ho(cey.a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e2) {
                FMLLog.log.error("Error performing GuiConfig action:", e2);
            }
            if (flag) {
                this.j.a(this.parentScreen);
            }
        } else if (button.k == 2001) {
            this.entryList.setAllToDefault(this.chkApplyGlobally.isChecked());
        } else if (button.k == 2002) {
            this.entryList.undoAllChanges(this.chkApplyGlobally.isChecked());
        }
    }

    public void k() throws IOException {
        super.k();
        this.entryList.p();
    }

    protected void a(int x, int y, int mouseEvent) throws IOException {
        if (mouseEvent != 0 || !this.entryList.a(x, y, mouseEvent)) {
            this.entryList.mouseClickedPassThru(x, y, mouseEvent);
            super.a(x, y, mouseEvent);
        }
    }

    protected void b(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.b(x, y, mouseEvent)) {
            super.b(x, y, mouseEvent);
        }
    }

    protected void a(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.j.a(this.parentScreen);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    public void e() {
        super.e();
        this.entryList.updateScreen();
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        this.entryList.a(mouseX, mouseY, partialTicks);
        this.a(this.q, this.title, this.l / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (title2 != null) {
            int strWidth = this.j.k.a(title2);
            int ellipsisWidth = this.j.k.a("...");
            if (strWidth > this.l - 6 && strWidth > ellipsisWidth) {
                title2 = this.j.k.a(title2, this.l - 6 - ellipsisWidth).trim() + "...";
            }
            this.a(this.q, title2, this.l / 2, 18, 0xFFFFFF);
        }
        this.btnUndoAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && this.entryList.hasChangedEntry(this.chkApplyGlobally.isChecked());
        this.btnDefaultAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && !this.entryList.areAllEntriesDefault(this.chkApplyGlobally.isChecked());
        super.a(mouseX, mouseY, partialTicks);
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cey.a((String)"fml.configgui.tooltip.undoAll", (Object[])new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cey.a((String)"fml.configgui.tooltip.resetAll", (Object[])new Object[0]).split("\n")), mouseX, mouseY);
        }
        if (this.checkBoxHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(Arrays.asList(cey.a((String)"fml.configgui.tooltip.applyGlobally", (Object[])new Object[0]).split("\n")), mouseX, mouseY);
        }
    }

    public void drawToolTip(List<String> stringList, int x, int y) {
        GuiUtils.drawHoveringText(stringList, x, y, this.l, this.m, 300, this.q);
    }
}

