/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.Map;
import net.minecraftforge.fml.client.GuiDupesFound;
import net.minecraftforge.fml.client.IDisplayableError;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuplicateModsFoundException
extends LoaderException
implements IDisplayableError {
    private static final long serialVersionUID = 1L;
    public SetMultimap<ModContainer, File> dupes;

    public DuplicateModsFoundException(SetMultimap<ModContainer, File> dupes) {
        this.dupes = dupes;
    }

    @Override
    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
        stream.println("Duplicate Mods:");
        for (Map.Entry e2 : this.dupes.entries()) {
            stream.println(String.format("\t%s : %s", ((ModContainer)e2.getKey()).getModId(), ((File)e2.getValue()).getAbsolutePath()));
        }
        stream.println("");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public blk createGui() {
        return new GuiDupesFound(this);
    }
}

