/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.asm.transformers.ModAPITransformer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;

public class ModAPIManager {
    public static final ModAPIManager INSTANCE = new ModAPIManager();
    private ModAPITransformer transformer;
    private ASMDataTable dataTable;
    private Map<String, APIContainer> apiContainers;

    public void registerDataTableAndParseAPI(ASMDataTable dataTable) {
        this.dataTable = dataTable;
        Set<ASMDataTable.ASMData> apiList = dataTable.getAll("net.minecraftforge.fml.common.API");
        this.apiContainers = Maps.newHashMap();
        for (ASMDataTable.ASMData data : apiList) {
            Map<String, Object> annotationInfo = data.getAnnotationInfo();
            String apiPackage = data.getClassName().substring(0, data.getClassName().indexOf(".package-info"));
            String providedAPI = (String)annotationInfo.get("provides");
            String apiOwner = (String)annotationInfo.get("owner");
            String apiVersion = (String)annotationInfo.get("apiVersion");
            APIContainer container = this.apiContainers.get(providedAPI);
            if (container == null) {
                container = new APIContainer(providedAPI, apiVersion, data.getCandidate().getModContainer(), VersionParser.parseVersionReference(apiOwner));
                this.apiContainers.put(providedAPI, container);
            } else {
                container.validate(providedAPI, apiOwner, apiVersion);
            }
            container.addOwnedPackage(apiPackage);
            for (ModContainer mc : data.getCandidate().getContainedMods()) {
                String embeddedIn = mc.getModId();
                if (container.currentReferents.contains(embeddedIn)) continue;
                FMLLog.log.debug("Found API {} (owned by {} providing {}) embedded in {}", (Object)apiPackage, (Object)apiOwner, (Object)providedAPI, (Object)embeddedIn);
                if (embeddedIn.equals(apiOwner)) continue;
                container.addAPIReference(embeddedIn);
            }
        }
        for (APIContainer container : this.apiContainers.values()) {
            for (String pkg : container.packages) {
                Set<ModCandidate> candidates = dataTable.getCandidatesFor(pkg);
                for (ModCandidate candidate : candidates) {
                    List candidateIds = candidate.getContainedMods().stream().map(ModContainer::getModId).collect(Collectors.toCollection(ArrayList::new));
                    if (candidateIds.contains(container.ownerMod.getLabel()) || container.currentReferents.containsAll(candidateIds)) continue;
                    FMLLog.log.info("Found mod(s) {} containing declared API package {} (owned by {}) without associated API reference", (Object)candidateIds, (Object)pkg, (Object)container.ownerMod);
                    container.addAPIReferences(candidateIds);
                }
            }
            if (this.apiContainers.containsKey(container.ownerMod.getLabel())) {
                APIContainer parent;
                ArtifactVersion owner = container.ownerMod;
                do {
                    if ((parent = this.apiContainers.get(owner.getLabel())) == container) {
                        FMLLog.log.trace("APIContainer {} is it's own parent. skipping", (Object)owner);
                        container.markSelfReferenced();
                        break;
                    }
                    FMLLog.log.trace("Removing upstream parent {} from {}", (Object)parent.ownerMod.getLabel(), (Object)container);
                    container.currentReferents.remove(parent.ownerMod.getLabel());
                    container.referredMods.remove(parent.ownerMod);
                } while (this.apiContainers.containsKey((owner = parent.ownerMod).getLabel()));
            }
            FMLLog.log.debug("Creating API container dummy for API {}: owner: {}, dependents: {}", (Object)container.providedAPI, (Object)container.ownerMod, (Object)container.referredMods);
        }
    }

    public void manageAPI(ModClassLoader modClassLoader, ModDiscoverer discoverer) {
        this.registerDataTableAndParseAPI(discoverer.getASMTable());
        this.transformer = modClassLoader.addModAPITransformer(this.dataTable);
    }

    public void injectAPIModContainers(List<ModContainer> mods, Map<String, ModContainer> nameLookup) {
        mods.addAll(this.apiContainers.values());
        nameLookup.putAll(this.apiContainers);
    }

    public void cleanupAPIContainers(List<ModContainer> mods) {
        mods.removeAll(this.apiContainers.values());
    }

    public boolean hasAPI(String modId) {
        return this.apiContainers.containsKey(modId);
    }

    public Iterable<? extends ModContainer> getAPIList() {
        return this.apiContainers.values();
    }

    private static class APIContainer
    extends DummyModContainer {
        private List<ArtifactVersion> referredMods;
        private ArtifactVersion ownerMod;
        private ArtifactVersion ourVersion;
        private String providedAPI;
        private File source;
        private String version;
        private Set<String> currentReferents;
        private Set<String> packages;
        private boolean selfReferenced;

        public APIContainer(String providedAPI, String apiVersion, File source, ArtifactVersion ownerMod) {
            this.providedAPI = providedAPI;
            this.version = apiVersion;
            this.ownerMod = ownerMod;
            this.ourVersion = new DefaultArtifactVersion(providedAPI, apiVersion);
            this.referredMods = Lists.newArrayList();
            this.source = source;
            this.currentReferents = Sets.newHashSet();
            this.packages = Sets.newHashSet();
        }

        @Override
        public File getSource() {
            return this.source;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getName() {
            return "API: " + this.providedAPI;
        }

        @Override
        public String getModId() {
            return this.providedAPI;
        }

        @Override
        public List<ArtifactVersion> getDependants() {
            return this.referredMods;
        }

        @Override
        public List<ArtifactVersion> getDependencies() {
            return this.selfReferenced ? ImmutableList.of() : ImmutableList.of(this.ownerMod);
        }

        @Override
        public ArtifactVersion getProcessedVersion() {
            return this.ourVersion;
        }

        public void validate(String providedAPI, String apiOwner, String apiVersion) {
            if (Loader.instance().getModClassLoader().containsSource(this.getSource())) {
                FMLLog.bigWarning("The API {} from source {} is loaded from an incompatible classloader. THIS WILL NOT WORK!", providedAPI, this.getSource().getAbsolutePath());
            }
        }

        @Override
        public String toString() {
            return "APIContainer{" + this.providedAPI + ":" + this.version + "}";
        }

        public void addAPIReference(String embedded) {
            if (this.currentReferents.add(embedded)) {
                this.referredMods.add(VersionParser.parseVersionReference(embedded));
            }
        }

        public void addOwnedPackage(String apiPackage) {
            this.packages.add(apiPackage);
        }

        public void addAPIReferences(List<String> candidateIds) {
            for (String modId : candidateIds) {
                this.addAPIReference(modId);
            }
        }

        void markSelfReferenced() {
            this.selfReferenced = true;
        }
    }
}

