/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.objectweb.asm.Type;

public class ModContainerFactory {
    public static Map<Type, Constructor<? extends ModContainer>> modTypes = Maps.newHashMap();
    private static ModContainerFactory INSTANCE = new ModContainerFactory();

    private ModContainerFactory() {
        this.registerContainerType(Type.getType(Mod.class), FMLModContainer.class);
    }

    public static ModContainerFactory instance() {
        return INSTANCE;
    }

    public void registerContainerType(Type type, Class<? extends ModContainer> container) {
        try {
            Constructor<? extends ModContainer> constructor = container.getConstructor(String.class, ModCandidate.class, Map.class);
            modTypes.put(type, constructor);
        }
        catch (Exception e2) {
            throw new RuntimeException("Critical error : cannot register mod container type " + container.getName() + ", it has an invalid constructor", e2);
        }
    }

    @Nullable
    public ModContainer build(ASMModParser modParser, File modSource, ModCandidate container) {
        String className = modParser.getASMType().getClassName();
        for (ModAnnotation ann : modParser.getAnnotations()) {
            if (!modTypes.containsKey(ann.getASMType())) continue;
            FMLLog.log.debug("Identified a mod of type {} ({}) - loading", (Object)ann.getASMType(), (Object)className);
            try {
                ModContainer ret = modTypes.get(ann.getASMType()).newInstance(className, container, ann.getValues());
                if (!ret.shouldLoadInEnvironment()) {
                    FMLLog.log.debug("Skipping mod {}, container opted to not load.", (Object)className);
                    return null;
                }
                return ret;
            }
            catch (Exception e2) {
                FMLLog.log.error("Unable to construct {} container", (Object)ann.getASMType().getClassName(), (Object)e2);
                return null;
            }
        }
        return null;
    }
}

