/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Modifier;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventSubscriberTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
        boolean isSubscriber = false;
        for (MethodNode methodNode : classNode.methods) {
            List anns = methodNode.visibleAnnotations;
            if (anns == null || !Iterables.any(anns, SubscribeEventPredicate.INSTANCE)) continue;
            if (Modifier.isPrivate(methodNode.access)) {
                String msg = "Cannot apply @SubscribeEvent to private method %s/%s%s";
                throw new RuntimeException(String.format(msg, classNode.name, methodNode.name, methodNode.desc));
            }
            methodNode.access = EventSubscriberTransformer.toPublic(methodNode.access);
            isSubscriber = true;
        }
        if (isSubscriber) {
            classNode.access = EventSubscriberTransformer.toPublic(classNode.access);
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private static int toPublic(int access) {
        return access & 0xFFFFFFF9 | 1;
    }

    private static class SubscribeEventPredicate
    implements Predicate<AnnotationNode> {
        static final SubscribeEventPredicate INSTANCE = new SubscribeEventPredicate();

        private SubscribeEventPredicate() {
        }

        @Override
        public boolean apply(AnnotationNode input) {
            return input.desc.equals("Lnet/minecraftforge/fml/common/eventhandler/SubscribeEvent;");
        }
    }
}

