/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.relauncher.CoreModManager;

public class ModDiscoverer {
    private List<ModCandidate> candidates = Lists.newArrayList();
    private ASMDataTable dataTable = new ASMDataTable();
    private List<File> nonModLibs = Lists.newArrayList();

    public void findClasspathMods(ModClassLoader modClassLoader) {
        ImmutableCollection knownLibraries = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(modClassLoader.getDefaultLibraries())).addAll(CoreModManager.getIgnoredMods())).addAll(CoreModManager.getReparseableCoremods())).build();
        File[] minecraftSources = modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            FMLLog.log.debug("Minecraft is a file at {}, loading", (Object)minecraftSources[0].getAbsolutePath());
            this.addCandidate(new ModCandidate(minecraftSources[0], minecraftSources[0], ContainerType.JAR, true, true));
        } else {
            int i2 = 0;
            for (File source : minecraftSources) {
                if (source.isFile()) {
                    if (knownLibraries.contains(source.getName()) || modClassLoader.isDefaultLibrary(source)) {
                        FMLLog.log.trace("Skipping known library file {}", (Object)source.getAbsolutePath());
                    } else {
                        FMLLog.log.debug("Found a minecraft related file at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                        this.addCandidate(new ModCandidate(source, source, ContainerType.JAR, i2 == 0, true));
                    }
                } else if (minecraftSources[i2].isDirectory()) {
                    FMLLog.log.debug("Found a minecraft related directory at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                    this.addCandidate(new ModCandidate(source, source, ContainerType.DIR, i2 == 0, true));
                }
                ++i2;
            }
        }
    }

    public List<ModContainer> identifyMods() {
        ArrayList<ModContainer> modList = Lists.newArrayList();
        for (ModCandidate candidate : this.candidates) {
            try {
                List<ModContainer> mods = candidate.explore(this.dataTable);
                if (mods.isEmpty() && !candidate.isClasspath()) {
                    this.nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                modList.addAll(mods);
            }
            catch (LoaderException le2) {
                FMLLog.log.warn("Identified a problem with the mod candidate {}, ignoring this source", (Object)candidate.getModContainer(), (Object)le2);
            }
        }
        return modList;
    }

    public ASMDataTable getASMTable() {
        return this.dataTable;
    }

    public List<File> getNonModLibs() {
        return this.nonModLibs;
    }

    public void addCandidate(ModCandidate candidate) {
        for (ModCandidate c2 : this.candidates) {
            if (!c2.getModContainer().equals(candidate.getModContainer())) continue;
            FMLLog.log.trace("  Skipping already in list {}", (Object)candidate.getModContainer());
            return;
        }
        this.candidates.add(candidate);
    }
}

