/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public class FMLPostInitializationEvent
extends FMLStateEvent {
    public FMLPostInitializationEvent(Object ... data) {
        super(data);
    }

    @Override
    public LoaderState.ModState getModState() {
        return LoaderState.ModState.POSTINITIALIZED;
    }

    public Optional<?> buildSoftDependProxy(String modId, String className, Object ... arguments) {
        if (Loader.isModLoaded(modId)) {
            Class[] args = (Class[])Arrays.stream(arguments).filter(Objects::nonNull).map(Object::getClass).toArray(Class[]::new);
            try {
                Class<?> clz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Constructor<?> ct = clz.getConstructor(args);
                return Optional.of(ct.newInstance(arguments));
            }
            catch (Exception e2) {
                FMLLog.log.info("An error occurred trying to build a soft depend proxy", (Throwable)e2);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

