/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.IHandshakeState;

public class HandshakeMessageHandler<S extends Enum<S>>
extends SimpleChannelInboundHandler<FMLHandshakeMessage> {
    private static final AttributeKey<IHandshakeState<?>> STATE = AttributeKey.valueOf("fml:handshake-state");
    private final AttributeKey<S> fmlHandshakeState = STATE;
    private final S initialState;
    private final S errorState;
    private final Class<S> stateType;

    public HandshakeMessageHandler(Class<S> stateType) {
        this.initialState = Enum.valueOf(stateType, "START");
        this.errorState = Enum.valueOf(stateType, "ERROR");
        this.stateType = stateType;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FMLHandshakeMessage msg) throws Exception {
        Enum state = (Enum)ctx.channel().attr(this.fmlHandshakeState).get();
        FMLLog.log.debug("{}: {}->{}:{}", (Object)this.stateType.getSimpleName(), (Object)msg.toString(this.stateType), (Object)state.getClass().getName().substring(state.getClass().getName().lastIndexOf(46) + 1), (Object)state);
        ((IHandshakeState)((Object)state)).accept(ctx, msg, s -> {
            FMLLog.log.debug("  Next: {}", (Object)s.name());
            ctx.channel().attr(this.fmlHandshakeState).set(s);
        });
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(this.fmlHandshakeState).set(this.initialState);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        Enum state = (Enum)ctx.channel().attr(this.fmlHandshakeState).get();
        FMLLog.log.debug("{}: null->{}:{}", (Object)this.stateType.getSimpleName(), (Object)state.getClass().getName().substring(state.getClass().getName().lastIndexOf(46) + 1), (Object)state);
        ((IHandshakeState)((Object)state)).accept(ctx, null, s -> {
            FMLLog.log.debug("  Next: {}", (Object)s.name());
            ctx.channel().attr(this.fmlHandshakeState).set(s);
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log.error("HandshakeMessageHandler exception", cause);
        ctx.channel().attr(this.fmlHandshakeState).set(this.errorState);
        super.exceptionCaught(ctx, cause);
    }
}

