/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.PacketLoggingHandler;
import net.minecraftforge.fml.common.network.handshake.ChannelRegistrationHandler;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeClientState;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeCodec;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeServerState;
import net.minecraftforge.fml.common.network.handshake.HandshakeInjector;
import net.minecraftforge.fml.common.network.handshake.HandshakeMessageHandler;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.ForgeRegistry;

public class NetworkDispatcher
extends SimpleChannelInboundHandler<ht<?>>
implements ChannelOutboundHandler {
    private static boolean DEBUG_HANDSHAKE = Boolean.parseBoolean(System.getProperty("fml.debugNetworkHandshake", "false"));
    public static final AttributeKey<NetworkDispatcher> FML_DISPATCHER = AttributeKey.valueOf("fml:dispatcher");
    public static final AttributeKey<Boolean> IS_LOCAL = AttributeKey.valueOf("fml:isLocal");
    public static final AttributeKey<Map<nf, ForgeRegistry.Snapshot>> FML_GAMEDATA_SNAPSHOT = AttributeKey.valueOf("fml:gameDataSnapshot");
    public final gw manager;
    private final pl scm;
    public oq player;
    private ConnectionState state;
    private ConnectionType connectionType;
    private final Side side;
    private final EmbeddedChannel handshakeChannel;
    private pa serverHandler;
    private hb netHandler;
    private Map<String, String> modList = Collections.emptyMap();
    private int overrideLoginDim;
    private MultiPartCustomPayload multipart = null;

    public static NetworkDispatcher get(gw manager) {
        return manager.channel().attr(FML_DISPATCHER).get();
    }

    public static NetworkDispatcher allocAndSet(gw manager) {
        NetworkDispatcher net = new NetworkDispatcher(manager);
        manager.channel().attr(FML_DISPATCHER).getAndSet(net);
        return net;
    }

    public static NetworkDispatcher allocAndSet(gw manager, pl scm) {
        NetworkDispatcher net = new NetworkDispatcher(manager, scm);
        manager.channel().attr(FML_DISPATCHER).getAndSet(net);
        return net;
    }

    public NetworkDispatcher(gw manager) {
        super(false);
        this.manager = manager;
        this.scm = null;
        this.side = Side.CLIENT;
        this.handshakeChannel = new EmbeddedChannel(new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeClientState>(FMLHandshakeClientState.class));
        this.handshakeChannel.attr(FML_DISPATCHER).set(this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set(Side.SERVER);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set("FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set(manager.c());
        if (DEBUG_HANDSHAKE) {
            PacketLoggingHandler.register(manager);
        }
    }

    public NetworkDispatcher(gw manager, pl scm) {
        super(false);
        this.manager = manager;
        this.scm = scm;
        this.side = Side.SERVER;
        this.handshakeChannel = new EmbeddedChannel(new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeServerState>(FMLHandshakeServerState.class));
        this.handshakeChannel.attr(FML_DISPATCHER).set(this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set(Side.CLIENT);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set("FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set(manager.c());
        if (DEBUG_HANDSHAKE) {
            PacketLoggingHandler.register(manager);
        }
    }

    public void serverToClientHandshake(oq player) {
        this.player = player;
        Boolean fml = this.manager.channel().attr(NetworkRegistry.FML_MARKER).get();
        if (fml != null && fml.booleanValue()) {
            this.insertIntoChannel();
        } else {
            this.serverInitiateHandshake();
            FMLLog.log.info("Connection received without FML marker, assuming vanilla.");
            this.insertIntoChannel();
            this.completeServerSideConnection(ConnectionType.VANILLA);
        }
    }

    protected void setModList(Map<String, String> modList) {
        this.modList = modList;
    }

    private void insertIntoChannel() {
        this.manager.channel().config().setAutoRead(false);
        this.manager.channel().pipeline().addBefore("packet_handler", "fml:packet_handler", this);
        if (this.state != null) {
            FMLLog.log.info("Opening channel which already seems to have a state set. This is a vanilla connection. Handshake handler will stop now");
            this.manager.channel().config().setAutoRead(true);
            return;
        }
        FMLLog.log.trace("Handshake channel activating");
        this.state = ConnectionState.OPENING;
        this.handshakeChannel.pipeline().fireUserEventTriggered(this);
        this.manager.channel().config().setAutoRead(true);
    }

    public void clientToServerHandshake() {
        this.insertIntoChannel();
    }

    int serverInitiateHandshake() {
        int dimension;
        this.state = ConnectionState.AWAITING_HANDSHAKE;
        this.serverHandler = new pa(this.scm.c(), this.manager, this.player){

            @Override
            public void e() {
                if (NetworkDispatcher.this.state == ConnectionState.FINALIZING) {
                    NetworkDispatcher.this.completeServerSideConnection(ConnectionType.MODDED);
                }
                if (this.b.a != this) {
                    return;
                }
                super.e();
            }
        };
        this.netHandler = this.serverHandler;
        this.player.a = null;
        this.manager.a(gx.b);
        fy playerNBT = this.scm.getPlayerNBT(this.player);
        if (playerNBT != null && DimensionManager.isDimensionRegistered(dimension = playerNBT.h("Dimension"))) {
            return dimension;
        }
        return 0;
    }

    void clientListenForServerHandshake() {
        this.manager.a(gx.b);
        this.netHandler = FMLCommonHandler.instance().getClientPlayHandler();
        this.state = ConnectionState.AWAITING_HANDSHAKE;
    }

    private void completeClientSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.log.info("[{}] Client side {} connection established", (Object)Thread.currentThread().getName(), (Object)this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientConnectedToServerEvent(this.manager, this.connectionType.name()));
    }

    private synchronized void completeServerSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.log.info("[{}] Server side {} connection established", (Object)Thread.currentThread().getName(), (Object)this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        if (DEBUG_HANDSHAKE) {
            this.manager.a(new ho("Handshake Complete review log file for details."));
        }
        this.scm.initializeConnectionToPlayer(this.manager, this.player, this.serverHandler);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ht<?> msg) throws Exception {
        boolean handled = false;
        if (msg instanceof lh) {
            handled = this.handleServerSideCustomPacket((lh)msg, ctx);
        } else if (msg instanceof iw) {
            handled = this.handleClientSideCustomPacket((iw)msg, ctx);
        } else if (this.state != ConnectionState.CONNECTED && this.state != ConnectionState.HANDSHAKECOMPLETE) {
            handled = this.handleVanilla(msg);
        }
        if (!handled) {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean handleVanilla(ht<?> msg) {
        if (this.state == ConnectionState.AWAITING_HANDSHAKE && msg instanceof jh) {
            this.handshakeChannel.pipeline().fireUserEventTriggered(msg);
        } else {
            FMLLog.log.info("Unexpected packet during modded negotiation - assuming vanilla or keepalives : {}", (Object)msg.getClass().getName());
        }
        return false;
    }

    public hb getNetHandler() {
        return this.netHandler;
    }

    public Map<String, String> getModList() {
        return Collections.unmodifiableMap(this.modList);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectionType && this.side == Side.SERVER) {
            FMLLog.log.info("Timeout occurred, assuming a vanilla client");
            this.kickVanilla();
        }
    }

    private void kickVanilla() {
        this.kickWithMessage("This is modded. No modded response received. Bye!");
    }

    public void kickWithMessage(String message) {
        FMLLog.log.error("Network Disconnect: {}", (Object)message);
        final ho TextComponentString = new ho(message);
        if (this.side == Side.CLIENT) {
            this.manager.a(TextComponentString);
        } else {
            this.manager.a(new iy(TextComponentString), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> result) {
                    NetworkDispatcher.this.manager.a(TextComponentString);
                }
            }, null);
        }
        this.manager.channel().config().setAutoRead(false);
    }

    private boolean handleClientSideCustomPacket(iw msg, ChannelHandlerContext context) {
        String channelName = msg.a();
        if ("FML|MP".equals(channelName)) {
            boolean result = this.handleMultiPartCustomPacket(msg, context);
            if (result) {
                msg.b().release();
            }
            return result;
        }
        if ("FML|HS".equals(channelName) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(proxy);
            for (Object e2 : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)e2, this, Side.CLIENT);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.CLIENT);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead(result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.CLIENT)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead(proxy);
            return true;
        }
        return false;
    }

    private boolean handleMultiPartCustomPacket(iw msg, ChannelHandlerContext context) {
        try {
            if (this.multipart == null) {
                this.multipart = new MultiPartCustomPayload(msg.b());
            } else {
                this.multipart.processPart(msg.b());
            }
        }
        catch (IOException e2) {
            this.kickWithMessage(e2.getMessage());
            this.multipart = null;
            return true;
        }
        if (this.multipart.isComplete()) {
            boolean result = this.handleClientSideCustomPacket(this.multipart, context);
            this.multipart = null;
            return result;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleServerSideCustomPacket(lh msg, ChannelHandlerContext context) {
        String channelName;
        if (this.state == ConnectionState.AWAITING_HANDSHAKE) {
            NetworkDispatcher networkDispatcher = this;
            synchronized (networkDispatcher) {
                if (this.state == ConnectionState.AWAITING_HANDSHAKE) {
                    this.state = ConnectionState.HANDSHAKING;
                }
            }
        }
        if ("FML|HS".equals(channelName = msg.a()) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(proxy);
            for (Object e2 : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)e2, this, Side.SERVER);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.SERVER);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead(result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.SERVER)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead(proxy);
            return true;
        }
        return false;
    }

    public void sendProxy(FMLProxyPacket msg) {
        if (!this.manager.g()) {
            msg = msg.copy();
        }
        this.manager.a(msg);
    }

    public void rejectHandshake(String result) {
        this.kickWithMessage(result);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.side == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientDisconnectionFromServerEvent(this.manager));
        } else {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.side == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientDisconnectionFromServerEvent(this.manager));
        } else {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.close(promise);
    }

    @Override
    @Deprecated
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof FMLProxyPacket) {
            if (this.side == Side.CLIENT) {
                ctx.write(((FMLProxyPacket)msg).toC17Packet(), promise);
            } else {
                List<ht<hw>> parts = ((FMLProxyPacket)msg).toS3FPackets();
                int sizeMinusOne = parts.size() - 1;
                for (int i2 = 0; i2 < sizeMinusOne; ++i2) {
                    ctx.write(parts.get(i2), ctx.voidPromise());
                }
                ctx.write(parts.get(sizeMinusOne), promise);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void completeHandshake(Side target) {
        if (this.state == ConnectionState.CONNECTED) {
            FMLLog.log.fatal("Attempt to double complete the network connection!");
            throw new FMLNetworkException("Attempt to double complete!");
        }
        if (this.side == Side.CLIENT) {
            this.completeClientSideConnection(ConnectionType.MODDED);
        } else {
            this.state = ConnectionState.FINALIZING;
        }
    }

    public void completeClientHandshake() {
        this.state = ConnectionState.HANDSHAKECOMPLETE;
    }

    public void abortClientHandshake(String type) {
        FMLLog.log.info("Aborting client handshake \"{}\"", (Object)type);
        this.completeClientSideConnection(ConnectionType.valueOf(type));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof ClosedChannelException)) {
            if (cause.getMessage() != null && cause.getMessage().contains("Connection reset by peer")) {
                FMLLog.log.debug("Muted NetworkDispatcher exception", cause);
            } else {
                FMLLog.log.error("NetworkDispatcher exception", cause);
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    private void cleanAttributes(ChannelHandlerContext ctx) {
        ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(null);
        ctx.channel().attr(NetworkRegistry.NET_HANDLER).set(null);
        ctx.channel().attr(FML_DISPATCHER).set(null);
        this.handshakeChannel.attr(FML_DISPATCHER).set(null);
        this.manager.channel().attr(FML_DISPATCHER).set(null);
        NetworkRegistry.INSTANCE.cleanAttributes();
    }

    public void setOverrideDimension(int overrideDim) {
        this.overrideLoginDim = overrideDim;
        FMLLog.log.debug("Received override dimension {}", (Object)overrideDim);
    }

    public int getOverrideDimension(jh packetIn) {
        FMLLog.log.debug("Overriding dimension: using {}", (Object)this.overrideLoginDim);
        return this.overrideLoginDim != 0 ? this.overrideLoginDim : packetIn.d();
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    private class MultiPartCustomPayload
    extends iw {
        private String channel;
        private byte[] data;
        private gy data_buf = null;
        private int part_count = 0;
        private int part_expected = 0;
        private int offset = 0;

        private MultiPartCustomPayload(gy preamble) throws IOException {
            this.channel = preamble.e(20);
            this.part_count = preamble.readUnsignedByte();
            int length = preamble.readInt();
            if (length <= 0 || length >= 267366480) {
                throw new IOException("The received FML MultiPart packet outside of valid length bounds, Max: 267366480, Received: " + length);
            }
            this.data = new byte[length];
            this.data_buf = new gy(Unpooled.wrappedBuffer(this.data));
        }

        public void processPart(gy input) throws IOException {
            int part = input.readByte() & 0xFF;
            if (part != this.part_expected) {
                throw new IOException("Received FML MultiPart packet out of order, Expected " + this.part_expected + " Got " + part);
            }
            int len = input.readableBytes();
            input.readBytes(this.data, this.offset, len);
            ++this.part_expected;
            this.offset += len;
        }

        public boolean isComplete() {
            return this.part_expected == this.part_count;
        }

        public String a() {
            return this.channel;
        }

        public gy b() {
            return this.data_buf;
        }
    }

    public static enum ConnectionType {
        MODDED,
        BUKKIT,
        VANILLA;

    }

    private static enum ConnectionState {
        OPENING,
        AWAITING_HANDSHAKE,
        HANDSHAKING,
        HANDSHAKECOMPLETE,
        FINALIZING,
        CONNECTED;

    }
}

